/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

abstract class PartitionedFanoutWriter<T>
extends BaseTaskWriter<T> {
    private final Map<PartitionKey, BaseTaskWriter.RollingFileWriter> writers = Maps.newHashMap();

    PartitionedFanoutWriter(PartitionSpec spec, FileFormat format, FileAppenderFactory<T> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
    }

    protected abstract PartitionKey partition(T var1);

    public void write(T row) throws IOException {
        PartitionKey partitionKey = this.partition(row);
        BaseTaskWriter.RollingFileWriter writer = this.writers.get(partitionKey);
        if (writer == null) {
            PartitionKey copiedKey = partitionKey.copy();
            writer = new BaseTaskWriter.RollingFileWriter((BaseTaskWriter)this, copiedKey);
            this.writers.put(copiedKey, writer);
        }
        writer.add(row);
    }

    public void close() throws IOException {
        if (!this.writers.isEmpty()) {
            for (PartitionKey key : this.writers.keySet()) {
                this.writers.get(key).close();
            }
            this.writers.clear();
        }
    }
}

