/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.BoundedOneInput;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.flink.sink.TaskWriterFactory;
import org.apache.iceberg.io.TaskWriter;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

class IcebergStreamWriter<T>
extends AbstractStreamOperator<DataFile>
implements OneInputStreamOperator<T, DataFile>,
BoundedOneInput {
    private static final long serialVersionUID = 1L;
    private final String fullTableName;
    private final TaskWriterFactory<T> taskWriterFactory;
    private transient TaskWriter<T> writer;
    private transient int subTaskId;
    private transient int attemptId;

    IcebergStreamWriter(String fullTableName, TaskWriterFactory<T> taskWriterFactory) {
        this.fullTableName = fullTableName;
        this.taskWriterFactory = taskWriterFactory;
        this.setChainingStrategy(ChainingStrategy.ALWAYS);
    }

    public void open() {
        this.subTaskId = this.getRuntimeContext().getIndexOfThisSubtask();
        this.attemptId = this.getRuntimeContext().getAttemptNumber();
        this.taskWriterFactory.initialize(this.subTaskId, this.attemptId);
        this.writer = this.taskWriterFactory.create();
    }

    public void prepareSnapshotPreBarrier(long checkpointId) throws Exception {
        for (DataFile dataFile : this.writer.complete()) {
            this.emit(dataFile);
        }
        this.writer = this.taskWriterFactory.create();
    }

    public void processElement(StreamRecord<T> element) throws Exception {
        this.writer.write(element.getValue());
    }

    public void dispose() throws Exception {
        super.dispose();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    public void endInput() throws IOException {
        for (DataFile dataFile : this.writer.complete()) {
            this.emit(dataFile);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("table_name", (Object)this.fullTableName).add("subtask_id", this.subTaskId).add("attempt_id", this.attemptId).toString();
    }

    private void emit(DataFile dataFile) {
        this.output.collect((Object)new StreamRecord((Object)dataFile));
    }
}

