/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestFiles;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.flink.sink.ManifestOutputFileFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

class FlinkManifestUtil {
    private static final int ICEBERG_FORMAT_VERSION = 2;
    private static final Long DUMMY_SNAPSHOT_ID = 0L;

    private FlinkManifestUtil() {
    }

    static ManifestFile writeDataFiles(OutputFile outputFile, PartitionSpec spec, List<DataFile> dataFiles) throws IOException {
        ManifestWriter writer;
        try (ManifestWriter closeableWriter = writer = ManifestFiles.write((int)2, (PartitionSpec)spec, (OutputFile)outputFile, (Long)DUMMY_SNAPSHOT_ID);){
            closeableWriter.addAll(dataFiles);
        }
        return writer.toManifestFile();
    }

    static List<DataFile> readDataFiles(ManifestFile manifestFile, FileIO io) throws IOException {
        try (ManifestReader dataFiles = ManifestFiles.read((ManifestFile)manifestFile, (FileIO)io);){
            ArrayList arrayList = Lists.newArrayList((Iterable)dataFiles);
            return arrayList;
        }
    }

    static ManifestOutputFileFactory createOutputFileFactory(Table table, String flinkJobId, int subTaskId, long attemptNumber) {
        TableOperations ops = ((HasTableOperations)table).operations();
        return new ManifestOutputFileFactory(ops, table.io(), table.properties(), flinkJobId, subTaskId, attemptNumber);
    }
}

