/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.List;
import org.apache.avro.io.Encoder;
import org.apache.avro.util.Utf8;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.DecimalUtil;

public class FlinkValueWriters {
    private FlinkValueWriters() {
    }

    static ValueWriter<StringData> strings() {
        return StringWriter.INSTANCE;
    }

    static ValueWriter<Integer> timeMicros() {
        return TimeMicrosWriter.INSTANCE;
    }

    static ValueWriter<TimestampData> timestampMicros() {
        return TimestampMicrosWriter.INSTANCE;
    }

    static ValueWriter<DecimalData> decimal(int precision, int scale) {
        return new DecimalWriter(precision, scale);
    }

    static <T> ValueWriter<ArrayData> array(ValueWriter<T> elementWriter, LogicalType elementType) {
        return new ArrayWriter(elementWriter, elementType);
    }

    static <K, V> ValueWriter<MapData> arrayMap(ValueWriter<K> keyWriter, LogicalType keyType, ValueWriter<V> valueWriter, LogicalType valueType) {
        return new ArrayMapWriter(keyWriter, keyType, valueWriter, valueType);
    }

    static <K, V> ValueWriter<MapData> map(ValueWriter<K> keyWriter, LogicalType keyType, ValueWriter<V> valueWriter, LogicalType valueType) {
        return new MapWriter(keyWriter, keyType, valueWriter, valueType);
    }

    static ValueWriter<RowData> row(List<ValueWriter<?>> writers, List<LogicalType> types) {
        return new RowWriter(writers, types);
    }

    static class RowWriter
    implements ValueWriter<RowData> {
        private final ValueWriter<?>[] writers;
        private final RowData.FieldGetter[] getters;

        private RowWriter(List<ValueWriter<?>> writers, List<LogicalType> types) {
            this.writers = (ValueWriter[])Array.newInstance(ValueWriter.class, writers.size());
            this.getters = new RowData.FieldGetter[writers.size()];
            for (int i = 0; i < writers.size(); ++i) {
                this.writers[i] = writers.get(i);
                this.getters[i] = RowData.createFieldGetter((LogicalType)types.get(i), (int)i);
            }
        }

        public void write(RowData row, Encoder encoder) throws IOException {
            for (int i = 0; i < this.writers.length; ++i) {
                if (row.isNullAt(i)) {
                    this.writers[i].write(null, encoder);
                    continue;
                }
                this.write(row, i, this.writers[i], encoder);
            }
        }

        private <T> void write(RowData row, int pos, ValueWriter<T> writer, Encoder encoder) throws IOException {
            writer.write(this.getters[pos].getFieldOrNull(row), encoder);
        }
    }

    private static class MapWriter<K, V>
    implements ValueWriter<MapData> {
        private final ValueWriter<K> keyWriter;
        private final ValueWriter<V> valueWriter;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        private MapWriter(ValueWriter<K> keyWriter, LogicalType keyType, ValueWriter<V> valueWriter, LogicalType valueType) {
            this.keyWriter = keyWriter;
            this.keyGetter = ArrayData.createElementGetter((LogicalType)keyType);
            this.valueWriter = valueWriter;
            this.valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        }

        public void write(MapData map, Encoder encoder) throws IOException {
            encoder.writeMapStart();
            int numElements = map.size();
            encoder.setItemCount((long)numElements);
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                this.keyWriter.write(this.keyGetter.getElementOrNull(keyArray, i), encoder);
                this.valueWriter.write(this.valueGetter.getElementOrNull(valueArray, i), encoder);
            }
            encoder.writeMapEnd();
        }
    }

    private static class ArrayMapWriter<K, V>
    implements ValueWriter<MapData> {
        private final ValueWriter<K> keyWriter;
        private final ValueWriter<V> valueWriter;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        private ArrayMapWriter(ValueWriter<K> keyWriter, LogicalType keyType, ValueWriter<V> valueWriter, LogicalType valueType) {
            this.keyWriter = keyWriter;
            this.keyGetter = ArrayData.createElementGetter((LogicalType)keyType);
            this.valueWriter = valueWriter;
            this.valueGetter = ArrayData.createElementGetter((LogicalType)valueType);
        }

        public void write(MapData map, Encoder encoder) throws IOException {
            encoder.writeArrayStart();
            int numElements = map.size();
            encoder.setItemCount((long)numElements);
            ArrayData keyArray = map.keyArray();
            ArrayData valueArray = map.valueArray();
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                this.keyWriter.write(this.keyGetter.getElementOrNull(keyArray, i), encoder);
                this.valueWriter.write(this.valueGetter.getElementOrNull(valueArray, i), encoder);
            }
            encoder.writeArrayEnd();
        }
    }

    private static class ArrayWriter<T>
    implements ValueWriter<ArrayData> {
        private final ValueWriter<T> elementWriter;
        private final ArrayData.ElementGetter elementGetter;

        private ArrayWriter(ValueWriter<T> elementWriter, LogicalType elementType) {
            this.elementWriter = elementWriter;
            this.elementGetter = ArrayData.createElementGetter((LogicalType)elementType);
        }

        public void write(ArrayData array, Encoder encoder) throws IOException {
            encoder.writeArrayStart();
            int numElements = array.size();
            encoder.setItemCount((long)numElements);
            for (int i = 0; i < numElements; ++i) {
                encoder.startItem();
                this.elementWriter.write(this.elementGetter.getElementOrNull(array, i), encoder);
            }
            encoder.writeArrayEnd();
        }
    }

    private static class TimestampMicrosWriter
    implements ValueWriter<TimestampData> {
        private static final TimestampMicrosWriter INSTANCE = new TimestampMicrosWriter();

        private TimestampMicrosWriter() {
        }

        public void write(TimestampData timestampData, Encoder encoder) throws IOException {
            long micros = timestampData.getMillisecond() * 1000L + (long)(timestampData.getNanoOfMillisecond() / 1000);
            encoder.writeLong(micros);
        }
    }

    private static class TimeMicrosWriter
    implements ValueWriter<Integer> {
        private static final TimeMicrosWriter INSTANCE = new TimeMicrosWriter();

        private TimeMicrosWriter() {
        }

        public void write(Integer timeMills, Encoder encoder) throws IOException {
            encoder.writeLong((long)(timeMills * 1000));
        }
    }

    private static class DecimalWriter
    implements ValueWriter<DecimalData> {
        private final int precision;
        private final int scale;
        private final ThreadLocal<byte[]> bytes;

        private DecimalWriter(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
            this.bytes = ThreadLocal.withInitial(() -> new byte[TypeUtil.decimalRequiredBytes((int)precision)]);
        }

        public void write(DecimalData d, Encoder encoder) throws IOException {
            encoder.writeFixed(DecimalUtil.toReusedFixLengthBytes((int)this.precision, (int)this.scale, (BigDecimal)d.toBigDecimal(), (byte[])this.bytes.get()));
        }
    }

    private static class StringWriter
    implements ValueWriter<StringData> {
        private static final StringWriter INSTANCE = new StringWriter();

        private StringWriter() {
        }

        public void write(StringData s, Encoder encoder) throws IOException {
            encoder.writeString(new Utf8(s.toBytes()));
        }
    }
}

