/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.data;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

abstract class FlinkSchemaVisitor<T> {
    FlinkSchemaVisitor() {
    }

    static <T> T visit(RowType flinkType, Schema schema, FlinkSchemaVisitor<T> visitor) {
        return FlinkSchemaVisitor.visit((LogicalType)flinkType, (Type)schema.asStruct(), visitor);
    }

    private static <T> T visit(LogicalType flinkType, Type iType, FlinkSchemaVisitor<T> visitor) {
        switch (iType.typeId()) {
            case STRUCT: {
                return FlinkSchemaVisitor.visitRecord(flinkType, iType.asStructType(), visitor);
            }
            case MAP: {
                MapType mapType = (MapType)flinkType;
                Types.MapType iMapType = iType.asMapType();
                T key = FlinkSchemaVisitor.visit(mapType.getKeyType(), iMapType.keyType(), visitor);
                T value = FlinkSchemaVisitor.visit(mapType.getValueType(), iMapType.valueType(), visitor);
                return visitor.map(iMapType, key, value, mapType.getKeyType(), mapType.getValueType());
            }
            case LIST: {
                ArrayType listType = (ArrayType)flinkType;
                Types.ListType iListType = iType.asListType();
                T element = FlinkSchemaVisitor.visit(listType.getElementType(), iListType.elementType(), visitor);
                return visitor.list(iListType, element, listType.getElementType());
            }
        }
        return visitor.primitive(iType.asPrimitiveType(), flinkType);
    }

    private static <T> T visitRecord(LogicalType flinkType, Types.StructType struct, FlinkSchemaVisitor<T> visitor) {
        Preconditions.checkArgument((boolean)(flinkType instanceof RowType), (String)"%s is not a RowType.", (Object)flinkType);
        RowType rowType = (RowType)flinkType;
        int fieldSize = struct.fields().size();
        ArrayList results = Lists.newArrayListWithExpectedSize((int)fieldSize);
        ArrayList fieldTypes = Lists.newArrayListWithExpectedSize((int)fieldSize);
        List nestedFields = struct.fields();
        for (int i = 0; i < fieldSize; ++i) {
            Types.NestedField iField = (Types.NestedField)nestedFields.get(i);
            int fieldIndex = rowType.getFieldIndex(iField.name());
            Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (String)"NestedField: %s is not found in flink RowType: %s", (Object)iField, (Object)rowType);
            LogicalType fieldFlinkType = rowType.getTypeAt(fieldIndex);
            fieldTypes.add(fieldFlinkType);
            results.add(FlinkSchemaVisitor.visit(fieldFlinkType, iField.type(), visitor));
        }
        return visitor.record(struct, results, fieldTypes);
    }

    public T record(Types.StructType iStruct, List<T> results, List<LogicalType> fieldTypes) {
        return null;
    }

    public T list(Types.ListType iList, T element, LogicalType elementType) {
        return null;
    }

    public T map(Types.MapType iMap, T key, T value, LogicalType keyType, LogicalType valueType) {
        return null;
    }

    public T primitive(Type.PrimitiveType iPrimitive, LogicalType flinkPrimitive) {
        return null;
    }
}

