/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.TableSinkFactory;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.iceberg.flink.FlinkCatalog;
import org.apache.iceberg.flink.IcebergTableSink;
import org.apache.iceberg.flink.IcebergTableSource;
import org.apache.iceberg.flink.TableLoader;

public class FlinkTableFactory
implements TableSinkFactory<RowData>,
TableSourceFactory<RowData> {
    private final FlinkCatalog catalog;

    public FlinkTableFactory(FlinkCatalog catalog) {
        this.catalog = catalog;
    }

    public TableSource<RowData> createTableSource(TableSourceFactory.Context context) {
        ObjectPath objectPath = context.getObjectIdentifier().toObjectPath();
        TableLoader tableLoader = this.createTableLoader(objectPath);
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getTable().getSchema());
        return new IcebergTableSource(tableLoader, tableSchema, context.getTable().getOptions());
    }

    public TableSink<RowData> createTableSink(TableSinkFactory.Context context) {
        ObjectPath objectPath = context.getObjectIdentifier().toObjectPath();
        TableLoader tableLoader = this.createTableLoader(objectPath);
        TableSchema tableSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)context.getTable().getSchema());
        return new IcebergTableSink(context.isBounded(), tableLoader, tableSchema);
    }

    public Map<String, String> requiredContext() {
        throw new UnsupportedOperationException("Iceberg Table Factory can not be loaded from Java SPI");
    }

    public List<String> supportedProperties() {
        throw new UnsupportedOperationException("Iceberg Table Factory can not be loaded from Java SPI");
    }

    private TableLoader createTableLoader(ObjectPath objectPath) {
        return TableLoader.fromCatalog(this.catalog.getCatalogLoader(), this.catalog.toIdentifier(objectPath));
    }
}

