/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.factories.CatalogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.flink.CatalogLoader;
import org.apache.iceberg.flink.FlinkCatalog;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class FlinkCatalogFactory
implements CatalogFactory {
    public static final String ICEBERG_CATALOG_TYPE = "catalog-type";
    public static final String HIVE_URI = "uri";
    public static final String HIVE_CLIENT_POOL_SIZE = "clients";
    public static final String HIVE_CONF_DIR = "hive-conf-dir";
    public static final String WAREHOUSE_LOCATION = "warehouse";
    public static final String DEFAULT_DATABASE = "default-database";
    public static final String BASE_NAMESPACE = "base-namespace";

    protected CatalogLoader createCatalogLoader(String name, Map<String, String> properties, org.apache.hadoop.conf.Configuration hadoopConf) {
        String catalogType;
        switch (catalogType = properties.getOrDefault(ICEBERG_CATALOG_TYPE, "hive")) {
            case "hive": {
                String uri = properties.get(HIVE_URI);
                String warehouse = properties.get(WAREHOUSE_LOCATION);
                int clientPoolSize = Integer.parseInt(properties.getOrDefault(HIVE_CLIENT_POOL_SIZE, "2"));
                String hiveConfDir = properties.get(HIVE_CONF_DIR);
                org.apache.hadoop.conf.Configuration newHadoopConf = FlinkCatalogFactory.mergeHiveConf(hadoopConf, hiveConfDir);
                return CatalogLoader.hive(name, newHadoopConf, uri, warehouse, clientPoolSize);
            }
            case "hadoop": {
                String warehouseLocation = properties.get(WAREHOUSE_LOCATION);
                return CatalogLoader.hadoop(name, hadoopConf, warehouseLocation);
            }
        }
        throw new UnsupportedOperationException("Unknown catalog type: " + catalogType);
    }

    public Map<String, String> requiredContext() {
        HashMap context = Maps.newHashMap();
        context.put("type", "iceberg");
        context.put("property-version", "1");
        return context;
    }

    public List<String> supportedProperties() {
        ArrayList properties = Lists.newArrayList();
        properties.add(ICEBERG_CATALOG_TYPE);
        properties.add(HIVE_URI);
        properties.add(HIVE_CLIENT_POOL_SIZE);
        properties.add(HIVE_CONF_DIR);
        properties.add(WAREHOUSE_LOCATION);
        properties.add(DEFAULT_DATABASE);
        properties.add(BASE_NAMESPACE);
        return properties;
    }

    public Catalog createCatalog(String name, Map<String, String> properties) {
        return this.createCatalog(name, properties, FlinkCatalogFactory.clusterHadoopConf());
    }

    protected Catalog createCatalog(String name, Map<String, String> properties, org.apache.hadoop.conf.Configuration hadoopConf) {
        CatalogLoader catalogLoader = this.createCatalogLoader(name, properties, hadoopConf);
        String defaultDatabase = properties.getOrDefault(DEFAULT_DATABASE, "default");
        String[] baseNamespace = properties.containsKey(BASE_NAMESPACE) ? Splitter.on((char)'.').splitToList((CharSequence)properties.get(BASE_NAMESPACE)).toArray(new String[0]) : new String[]{};
        boolean cacheEnabled = Boolean.parseBoolean(properties.getOrDefault("cache-enabled", "true"));
        return new FlinkCatalog(name, defaultDatabase, baseNamespace, catalogLoader, cacheEnabled);
    }

    private static org.apache.hadoop.conf.Configuration mergeHiveConf(org.apache.hadoop.conf.Configuration hadoopConf, String hiveConfDir) {
        org.apache.hadoop.conf.Configuration newConf = new org.apache.hadoop.conf.Configuration(hadoopConf);
        if (!Strings.isNullOrEmpty((String)hiveConfDir)) {
            Preconditions.checkState((boolean)Files.exists(Paths.get(hiveConfDir, "hive-site.xml"), new LinkOption[0]), (String)"There should be a hive-site.xml file under the directory %s", (Object)hiveConfDir);
            newConf.addResource(new Path(hiveConfDir, "hive-site.xml"));
        } else {
            URL configFile = CatalogLoader.class.getClassLoader().getResource("hive-site.xml");
            if (configFile != null) {
                newConf.addResource(configFile);
            }
        }
        return newConf;
    }

    public static org.apache.hadoop.conf.Configuration clusterHadoopConf() {
        return HadoopUtils.getHadoopConfiguration((Configuration)GlobalConfiguration.loadConfiguration());
    }
}

