/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;

public interface CatalogLoader
extends Serializable {
    public Catalog loadCatalog();

    public static CatalogLoader hadoop(String name, Configuration hadoopConf, String warehouseLocation) {
        return new HadoopCatalogLoader(name, hadoopConf, warehouseLocation);
    }

    public static CatalogLoader hive(String name, Configuration hadoopConf, String uri, String warehouse, int clientPoolSize) {
        return new HiveCatalogLoader(name, hadoopConf, uri, warehouse, clientPoolSize);
    }

    public static class HiveCatalogLoader
    implements CatalogLoader {
        private final String catalogName;
        private final SerializableConfiguration hadoopConf;
        private final String uri;
        private final String warehouse;
        private final int clientPoolSize;

        private HiveCatalogLoader(String catalogName, Configuration conf, String uri, String warehouse, int clientPoolSize) {
            this.catalogName = catalogName;
            this.hadoopConf = new SerializableConfiguration(conf);
            this.uri = uri;
            this.warehouse = warehouse;
            this.clientPoolSize = clientPoolSize;
        }

        @Override
        public Catalog loadCatalog() {
            return new HiveCatalog(this.catalogName, this.uri, this.warehouse, this.clientPoolSize, this.hadoopConf.get());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("uri", (Object)this.uri).add("warehouse", (Object)this.warehouse).add("clientPoolSize", this.clientPoolSize).toString();
        }
    }

    public static class HadoopCatalogLoader
    implements CatalogLoader {
        private final String catalogName;
        private final SerializableConfiguration hadoopConf;
        private final String warehouseLocation;

        private HadoopCatalogLoader(String catalogName, Configuration conf, String warehouseLocation) {
            this.catalogName = catalogName;
            this.hadoopConf = new SerializableConfiguration(conf);
            this.warehouseLocation = warehouseLocation;
        }

        @Override
        public Catalog loadCatalog() {
            return new HadoopCatalog(this.catalogName, this.hadoopConf.get(), this.warehouseLocation);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("catalogName", (Object)this.catalogName).add("warehouseLocation", (Object)this.warehouseLocation).toString();
        }
    }
}

