/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.ser;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ser.CommitMetaSer;

public class CommitMetaDeserializer
extends StdDeserializer<CommitMeta> {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public CommitMetaDeserializer() {
        super(CommitMeta.class);
    }

    private void toArray(ObjectNode node, String singleAttr, String arrayAttr) {
        if (!node.has(arrayAttr)) {
            JsonNode value;
            ArrayNode array = node.withArray(arrayAttr);
            if (node.has(singleAttr) && !(value = node.get(singleAttr)).isNull()) {
                array.add(value);
            }
        }
        node.remove(singleAttr);
    }

    private void toMapOfLists(ObjectNode node, String singleAttr, String arrayAttr) {
        if (!node.has(arrayAttr)) {
            ObjectNode mapOfLists = node.putObject(arrayAttr);
            if (node.has(singleAttr) && node.get(singleAttr).isObject()) {
                ObjectNode map = (ObjectNode)node.get(singleAttr);
                Iterator<Map.Entry<String, JsonNode>> it = map.fields();
                while (it.hasNext()) {
                    Map.Entry<String, JsonNode> entry = it.next();
                    mapOfLists.putArray(entry.getKey()).add(entry.getValue());
                }
            }
        }
        node.remove(singleAttr);
    }

    @Override
    public CommitMeta deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        ObjectNode node = p.readValueAs(ObjectNode.class);
        this.toArray(node, "author", "authors");
        this.toArray(node, "signedOffBy", "allSignedOffBy");
        this.toMapOfLists(node, "properties", "allProperties");
        CommitMetaSer value = MAPPER.convertValue((Object)node, CommitMetaSer.class);
        return CommitMeta.builder().from(value).build();
    }
}

