/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.Elements;
import org.projectnessie.model.Namespace;

@ParametersAreNonnullByDefault
@Generated(from="Namespace", generator="Immutables")
@Immutable
public final class ImmutableNamespace
extends Namespace {
    @Nullable
    private final String id;
    private final transient String name;
    private final List<String> elements;
    private final Map<String, String> properties;

    private ImmutableNamespace(@Nullable String id, List<String> elements, Map<String, String> properties) {
        this.id = id;
        this.elements = elements;
        this.properties = properties;
        this.name = Objects.requireNonNull(super.name(), "name");
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="elements")
    public List<String> getElements() {
        return this.elements;
    }

    @Override
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public final ImmutableNamespace withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return ImmutableNamespace.validate(new ImmutableNamespace(value, this.elements, this.properties));
    }

    public final ImmutableNamespace withElements(String ... elements) {
        List<String> newValue = ImmutableNamespace.createUnmodifiableList(false, ImmutableNamespace.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableNamespace.validate(new ImmutableNamespace(this.id, newValue, this.properties));
    }

    public final ImmutableNamespace withElements(Iterable<String> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<String> newValue = ImmutableNamespace.createUnmodifiableList(false, ImmutableNamespace.createSafeList(elements, true, false));
        return ImmutableNamespace.validate(new ImmutableNamespace(this.id, newValue, this.properties));
    }

    public final ImmutableNamespace withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableNamespace.createUnmodifiableMap(true, false, entries);
        return ImmutableNamespace.validate(new ImmutableNamespace(this.id, this.elements, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNamespace && this.equalsByValue((ImmutableNamespace)another);
    }

    private boolean equalsByValue(ImmutableNamespace another) {
        return Objects.equals(this.id, another.id) && this.name.equals(another.name) && this.elements.equals(another.elements) && this.properties.equals(another.properties);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.id);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.elements.hashCode();
        h2 += (h2 << 5) + this.properties.hashCode();
        return h2;
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNamespace fromJson(Json json) {
        Builder builder = ImmutableNamespace.builder();
        if (json._id != null) {
            builder.id(json._id);
        }
        if (json._elements != null) {
            builder.addAllElements(json._elements);
        }
        if (json._properties != null) {
            builder.putAllProperties(json._properties);
        }
        return builder.build();
    }

    private static ImmutableNamespace validate(ImmutableNamespace instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableNamespace copyOf(Namespace instance) {
        if (instance instanceof ImmutableNamespace) {
            return (ImmutableNamespace)instance;
        }
        return ImmutableNamespace.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Namespace", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private String id;
        private List<String> elements = new ArrayList<String>();
        private Map<String, String> properties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(Namespace instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Elements instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String idValue;
            Object instance;
            long bits = 0L;
            if (object instanceof Namespace) {
                instance = (Namespace)object;
                this.putAllProperties(((Namespace)instance).getProperties());
                if ((bits & 1L) == 0L) {
                    this.addAllElements(((Namespace)instance).getElements());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    idValue = ((Content)instance).getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof Elements) {
                instance = (Elements)object;
                if ((bits & 1L) == 0L) {
                    this.addAllElements(instance.getElements());
                    bits |= 1L;
                }
            }
            if (object instanceof Content) {
                instance = (Content)object;
                if ((bits & 2L) == 0L) {
                    idValue = ((Content)instance).getId();
                    if (idValue != null) {
                        this.id(idValue);
                    }
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder addElements(String element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        public final Builder addElements(String ... elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        @JsonProperty(value="elements")
        public final Builder elements(Iterable<String> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        public final Builder addAllElements(Iterable<String> elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
            return this;
        }

        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "properties value for key: " + k : null));
            return this;
        }

        @JsonProperty(value="properties")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "properties value for key: " + k : null));
            }
            return this;
        }

        public ImmutableNamespace build() {
            return ImmutableNamespace.validate(new ImmutableNamespace(this.id, ImmutableNamespace.createUnmodifiableList(true, this.elements), ImmutableNamespace.createUnmodifiableMap(false, false, this.properties)));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="Namespace", generator="Immutables")
    static final class Json
    extends Namespace {
        @JsonIgnore
        String _id;
        @JsonIgnore
        List<String> _elements = Collections.emptyList();
        @JsonIgnore
        Map<String, String> _properties = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this._id = id;
        }

        @JsonProperty(value="elements")
        public void setElements(List<String> elements) {
            this._elements = elements;
        }

        @JsonProperty(value="properties")
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setProperties(Map<String, String> properties) {
            this._properties = properties;
        }

        @Override
        public Namespace withId(String id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getElements() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

