/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.Detached;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;

@ParametersAreNonnullByDefault
@Generated(from="Detached", generator="Immutables")
@Immutable
public final class ImmutableDetached
implements Detached {
    private final String hash;
    @Nullable
    private final ReferenceMetadata metadata;

    private ImmutableDetached(String hash, @Nullable ReferenceMetadata metadata) {
        this.hash = Objects.requireNonNull(hash, "hash");
        this.metadata = metadata;
    }

    private ImmutableDetached(ImmutableDetached original, String hash, @Nullable ReferenceMetadata metadata) {
        this.hash = hash;
        this.metadata = metadata;
    }

    @Override
    @JsonProperty(value="hash", required=true)
    public String getHash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public ReferenceMetadata getMetadata() {
        return this.metadata;
    }

    public final ImmutableDetached withHash(String value) {
        String newValue = Objects.requireNonNull(value, "hash");
        if (this.hash.equals(newValue)) {
            return this;
        }
        return ImmutableDetached.validate(new ImmutableDetached(this, newValue, this.metadata));
    }

    public final ImmutableDetached withMetadata(@Nullable ReferenceMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        return ImmutableDetached.validate(new ImmutableDetached(this, this.hash, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDetached && this.equalsByValue((ImmutableDetached)another);
    }

    private boolean equalsByValue(ImmutableDetached another) {
        return this.hash.equals(another.hash) && Objects.equals(this.metadata, another.metadata);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.hash.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.metadata);
        return h2;
    }

    public String toString() {
        return "Detached{hash=" + this.hash + ", metadata=" + String.valueOf(this.metadata) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDetached fromJson(Json json) {
        Builder builder = ImmutableDetached.builder();
        if (json._hash != null) {
            builder.hash(json._hash);
        }
        if (json._metadata != null) {
            builder.metadata(json._metadata);
        }
        return builder.build();
    }

    public static ImmutableDetached of(String hash, @Nullable ReferenceMetadata metadata) {
        return ImmutableDetached.validate(new ImmutableDetached(hash, metadata));
    }

    private static ImmutableDetached validate(ImmutableDetached instance) {
        instance.checkHash();
        return instance;
    }

    public static ImmutableDetached copyOf(Detached instance) {
        if (instance instanceof ImmutableDetached) {
            return (ImmutableDetached)instance;
        }
        return ImmutableDetached.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Detached", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private long initBits = 1L;
        private String hash;
        private ReferenceMetadata metadata;

        private Builder() {
        }

        public final Builder from(Detached instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ReferenceMetadata metadataValue;
            Reference instance;
            long bits = 0L;
            if (object instanceof Detached) {
                instance = (Detached)object;
                if ((bits & 1L) == 0L) {
                    metadataValue = instance.getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hash(instance.getHash());
                    bits |= 2L;
                }
            }
            if (object instanceof Reference) {
                instance = (Reference)object;
                if ((bits & 1L) == 0L) {
                    metadataValue = instance.getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.hash(instance.getHash());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty(value="hash", required=true)
        public final Builder hash(String hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(@Nullable ReferenceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public ImmutableDetached build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableDetached.validate(new ImmutableDetached(null, this.hash, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build Detached, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @Generated(from="Detached", generator="Immutables")
    static final class Json
    implements Detached {
        @JsonIgnore
        String _hash;
        @JsonIgnore
        ReferenceMetadata _metadata;

        Json() {
        }

        @JsonProperty(value="hash", required=true)
        public void setHash(String hash) {
            this._hash = hash;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable ReferenceMetadata metadata) {
            this._metadata = metadata;
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }
    }
}

