/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OAuth2TokenRefreshExecutor
extends ScheduledThreadPoolExecutor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2TokenRefreshExecutor.class);
    private final OAuth2ClientConfig config;

    OAuth2TokenRefreshExecutor(OAuth2ClientConfig config) {
        super(1, new OAuth2TokenRefreshThreadFactory(config.getClientName()));
        this.config = config;
        this.setKeepAliveTime(config.getBackgroundThreadIdleTimeout().toNanos(), TimeUnit.NANOSECONDS);
        this.allowCoreThreadTimeOut(true);
    }

    @Override
    public void close() {
        if (!this.isShutdown()) {
            this.shutdown();
            try {
                if (!this.awaitTermination(10L, TimeUnit.SECONDS) && !this.shutdownNow().isEmpty()) {
                    LOGGER.warn("[{}] OAuth2 token refresh executor did not terminate within 10 seconds", (Object)this.config.getClientName());
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("[{}] OAuth2 token refresh executor termination interrupted", (Object)this.config.getClientName(), (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class OAuth2TokenRefreshThreadFactory
    implements ThreadFactory {
        private final String clientName;
        private final AtomicInteger threadCounter = new AtomicInteger();

        public OAuth2TokenRefreshThreadFactory(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public Thread newThread(@Nonnull Runnable r) {
            Thread thread = new Thread(() -> {
                LOGGER.debug("[{}] Starting new OAuth2 token refresh thread", (Object)this.clientName);
                try {
                    r.run();
                }
                finally {
                    LOGGER.debug("[{}] OAuth2 token refresh thread exiting", (Object)this.clientName);
                }
            });
            thread.setName(this.clientName + "-token-refresh-" + this.threadCounter.incrementAndGet());
            thread.setDaemon(true);
            return thread;
        }
    }
}

