/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.DeviceCodeRequest;
import org.projectnessie.client.auth.oauth2.PublicClientRequest;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DeviceCodeRequest", generator="Immutables")
@Immutable
final class ImmutableDeviceCodeRequest
implements DeviceCodeRequest {
    @Nullable
    private final String clientId;
    @Nullable
    private final String scope;

    private ImmutableDeviceCodeRequest(@Nullable String clientId, @Nullable String scope) {
        this.clientId = clientId;
        this.scope = scope;
    }

    @Override
    @JsonProperty(value="client_id")
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    public final ImmutableDeviceCodeRequest withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableDeviceCodeRequest(value, this.scope);
    }

    public final ImmutableDeviceCodeRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableDeviceCodeRequest(this.clientId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeviceCodeRequest && this.equalsByValue((ImmutableDeviceCodeRequest)another);
    }

    private boolean equalsByValue(ImmutableDeviceCodeRequest another) {
        return Objects.equals(this.clientId, another.clientId) && Objects.equals(this.scope, another.scope);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        return h2;
    }

    public String toString() {
        return "DeviceCodeRequest{clientId=" + this.clientId + ", scope=" + this.scope + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDeviceCodeRequest fromJson(Json json) {
        Builder builder = ImmutableDeviceCodeRequest.builder();
        if (json._clientId != null) {
            builder.clientId(json._clientId);
        }
        if (json._scope != null) {
            builder.scope(json._scope);
        }
        return builder.build();
    }

    public static ImmutableDeviceCodeRequest copyOf(DeviceCodeRequest instance) {
        if (instance instanceof ImmutableDeviceCodeRequest) {
            return (ImmutableDeviceCodeRequest)instance;
        }
        return ImmutableDeviceCodeRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeviceCodeRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements DeviceCodeRequest.Builder {
        private String clientId;
        private String scope;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DeviceCodeRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PublicClientRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String clientIdValue;
            PublicClientRequest instance;
            long bits = 0L;
            if (object instanceof DeviceCodeRequest) {
                String scopeValue;
                instance = (DeviceCodeRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
                if ((scopeValue = instance.getScope()) != null) {
                    this.scope(scopeValue);
                }
            }
            if (object instanceof PublicClientRequest) {
                instance = (PublicClientRequest)object;
                if ((bits & 1L) == 0L) {
                    clientIdValue = instance.getClientId();
                    if (clientIdValue != null) {
                        this.clientId(clientIdValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="client_id")
        @CanIgnoreReturnValue
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public ImmutableDeviceCodeRequest build() {
            return new ImmutableDeviceCodeRequest(this.clientId, this.scope);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="DeviceCodeRequest", generator="Immutables")
    static final class Json
    implements DeviceCodeRequest {
        @JsonIgnore
        String _clientId;
        @JsonIgnore
        String _scope;

        Json() {
        }

        @JsonProperty(value="client_id")
        public void setClientId(@Nullable String clientId) {
            this._clientId = clientId;
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this._scope = scope;
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }
    }
}

