/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.projectnessie.client.auth.oauth2.AbstractFlow;
import org.projectnessie.client.auth.oauth2.AuthorizationCodeTokenRequest;
import org.projectnessie.client.auth.oauth2.AuthorizationCodeTokenResponse;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.OAuth2Utils;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.impl.HttpUtils;
import org.projectnessie.client.http.impl.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthorizationCodeFlow
extends AbstractFlow {
    static final String CONTEXT_PATH = "/nessie-client/auth";
    static final String MSG_PREFIX = "[nessie-oauth2-client] ";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthorizationCodeFlow.class);
    private static final String HTML_TEMPLATE_OK = "<html><body><h1>Authentication successful</h1><p>You can close this page now.</p></body></html>";
    private static final String HTML_TEMPLATE_FAILED = "<html><body><h1>Authentication failed</h1><p>Could not obtain access token: %s</p></body></html>";
    private static final int STATE_LENGTH = 16;
    private final PrintStream console;
    private final String state;
    private final HttpServer server;
    private final String redirectUri;
    private final URI authorizationUri;
    private final Duration flowTimeout;
    private final CompletableFuture<HttpExchange> redirectUriFuture = new CompletableFuture();
    private final CompletableFuture<Tokens> tokensFuture;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final Phaser inflightRequestsPhaser = new Phaser(1);

    AuthorizationCodeFlow(OAuth2ClientConfig config) {
        super(config);
        this.console = config.getConsole();
        this.flowTimeout = config.getAuthorizationCodeFlowTimeout();
        this.tokensFuture = ((CompletableFuture)((CompletableFuture)this.redirectUriFuture.thenApply(this::extractAuthorizationCode)).thenApply(this::fetchNewTokens)).whenComplete((tokens, error) -> this.log((Throwable)error));
        this.closeFuture.thenRun(this::doClose);
        this.server = AuthorizationCodeFlow.createServer(config.getAuthorizationCodeFlowWebServerPort().orElse(0), this::doRequest);
        this.state = OAuth2Utils.randomAlphaNumString(16);
        this.redirectUri = String.format("http://localhost:%d%s", this.server.getAddress().getPort(), CONTEXT_PATH);
        URI authEndpoint = config.getResolvedAuthEndpoint();
        this.authorizationUri = new UriBuilder(authEndpoint.resolve("/")).path(authEndpoint.getPath()).queryParam("response_type", "code").queryParam("client_id", config.getClientId()).queryParam("scope", config.getScopes().stream().reduce((a, b) -> a + " " + b).orElse(null)).queryParam("redirect_uri", this.redirectUri).queryParam("state", this.state).build();
        LOGGER.debug("Authorization Code Flow: started, redirect URI: {}", (Object)this.redirectUri);
    }

    @Override
    public void close() {
        this.closeFuture.complete(null);
    }

    private void doClose() {
        this.inflightRequestsPhaser.arriveAndAwaitAdvance();
        LOGGER.debug("Authorization Code Flow: closing");
        this.server.stop(0);
    }

    private void abort() {
        this.tokensFuture.cancel(true);
        this.redirectUriFuture.cancel(true);
    }

    @Override
    public Tokens fetchNewTokens(@Nullable Tokens ignored) {
        this.console.println();
        this.console.println("[nessie-oauth2-client] ======= Nessie authentication required =======");
        this.console.println("[nessie-oauth2-client] Browse to the following URL to continue:");
        this.console.println(MSG_PREFIX + String.valueOf(this.authorizationUri));
        this.console.println();
        this.console.flush();
        try {
            return this.tokensFuture.get(this.flowTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            LOGGER.error("Timed out waiting for authorization code.");
            this.abort();
            throw new RuntimeException("Timed out waiting waiting for authorization code", e);
        }
        catch (InterruptedException e) {
            this.abort();
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            this.abort();
            Throwable cause = e.getCause();
            LOGGER.error("Authentication failed: {}", (Object)cause.toString());
            if (cause instanceof HttpClientException) {
                throw (HttpClientException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private void doRequest(HttpExchange exchange) {
        LOGGER.debug("Authorization Code Flow: received request");
        this.inflightRequestsPhaser.register();
        this.redirectUriFuture.complete(exchange);
        ((CompletableFuture)((CompletableFuture)this.tokensFuture.handle((tokens, error) -> this.doResponse(exchange, (Throwable)error))).whenComplete((v, error) -> exchange.close())).whenComplete((v, error) -> this.inflightRequestsPhaser.arriveAndDeregister());
    }

    private Void doResponse(HttpExchange exchange, Throwable error) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authorization Code Flow: sending response, error: {}", (Object)(error == null ? "none" : error.toString()));
        }
        try {
            if (error == null) {
                AuthorizationCodeFlow.writeResponse(exchange, 200, HTML_TEMPLATE_OK, new Object[0]);
            } else {
                AuthorizationCodeFlow.writeResponse(exchange, 401, HTML_TEMPLATE_FAILED, error.toString());
            }
        }
        catch (IOException e) {
            LOGGER.debug("Authorization Code Flow: error writing response", (Throwable)e);
        }
        return null;
    }

    private String extractAuthorizationCode(HttpExchange exchange) {
        LOGGER.debug("Authorization Code Flow: extracting code");
        Map<String, String> params = HttpUtils.parseQueryString(exchange.getRequestURI().getQuery());
        if (!this.state.equals(params.get("state"))) {
            throw new IllegalArgumentException("Missing or invalid state");
        }
        String code = params.get("code");
        if (code == null || code.isEmpty()) {
            throw new IllegalArgumentException("Missing authorization code");
        }
        return code;
    }

    private Tokens fetchNewTokens(String code) {
        LOGGER.debug("Authorization Code Flow: fetching new tokens");
        AuthorizationCodeTokenRequest.Builder request = AuthorizationCodeTokenRequest.builder().code(code).redirectUri(this.redirectUri);
        Tokens tokens = this.invokeTokenEndpoint(request, AuthorizationCodeTokenResponse.class);
        LOGGER.debug("Authorization Code Flow: new tokens received");
        return tokens;
    }

    private void log(Throwable error) {
        if (LOGGER.isDebugEnabled()) {
            if (error == null) {
                LOGGER.debug("Authorization Code Flow: tokens received");
            } else {
                LOGGER.debug("Authorization Code Flow: error fetching tokens: {}", (Object)error.toString());
            }
        }
    }

    private static HttpServer createServer(int port, HttpHandler handler) {
        HttpServer server;
        try {
            server = HttpServer.create();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        server.createContext(CONTEXT_PATH, handler);
        InetAddress local = InetAddress.getLoopbackAddress();
        try {
            server.bind(new InetSocketAddress(local, port), 0);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        server.start();
        return server;
    }

    private static void writeResponse(HttpExchange exchange, int status, String htmlTemplate, Object ... args) throws IOException {
        String html = String.format(htmlTemplate, args);
        exchange.getResponseHeaders().add("Content-Type", "text/html");
        exchange.sendResponseHeaders(status, html.length());
        exchange.getResponseBody().write(html.getBytes(StandardCharsets.UTF_8));
    }
}

