/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.Comparator;
import org.locationtech.jts.algorithm.PolygonNodeTopology;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.relateng.RelateGeometry;

class NodeSection
implements Comparable<NodeSection> {
    private boolean isA;
    private int dim;
    private int id;
    private int ringId;
    private boolean isNodeAtVertex;
    private Coordinate nodePt;
    private Coordinate v0;
    private Coordinate v1;
    private Geometry poly;

    public static boolean isAreaArea(NodeSection a, NodeSection b) {
        return a.dimension() == 2 && b.dimension() == 2;
    }

    public NodeSection(boolean isA, int dimension, int id, int ringId, Geometry poly, boolean isNodeAtVertex, Coordinate v0, Coordinate nodePt, Coordinate v1) {
        this.isA = isA;
        this.dim = dimension;
        this.id = id;
        this.ringId = ringId;
        this.poly = poly;
        this.isNodeAtVertex = isNodeAtVertex;
        this.nodePt = nodePt;
        this.v0 = v0;
        this.v1 = v1;
    }

    public Coordinate getVertex(int i) {
        return i == 0 ? this.v0 : this.v1;
    }

    public Coordinate nodePt() {
        return this.nodePt;
    }

    public int dimension() {
        return this.dim;
    }

    public int id() {
        return this.id;
    }

    public int ringId() {
        return this.ringId;
    }

    public Geometry getPolygonal() {
        return this.poly;
    }

    public boolean isShell() {
        return this.ringId == 0;
    }

    public boolean isArea() {
        return this.dim == 2;
    }

    public boolean isA() {
        return this.isA;
    }

    public boolean isSameGeometry(NodeSection ns) {
        return this.isA() == ns.isA();
    }

    public boolean isSamePolygon(NodeSection ns) {
        return this.isA() == ns.isA() && this.id() == ns.id();
    }

    public boolean isNodeAtVertex() {
        return this.isNodeAtVertex;
    }

    public boolean isProper() {
        return !this.isNodeAtVertex;
    }

    public static boolean isProper(NodeSection a, NodeSection b) {
        return a.isProper() && b.isProper();
    }

    public String toString() {
        String geomName = RelateGeometry.name(this.isA);
        String atVertexInd = this.isNodeAtVertex ? "-V-" : "---";
        String polyId = this.id >= 0 ? "[" + this.id + ":" + this.ringId + "]" : "";
        return String.format("%s%d%s: %s %s %s", geomName, this.dim, polyId, this.edgeRep(this.v0, this.nodePt), atVertexInd, this.edgeRep(this.nodePt, this.v1));
    }

    private String edgeRep(Coordinate p0, Coordinate p1) {
        if (p0 == null || p1 == null) {
            return "null";
        }
        return WKTWriter.toLineString(p0, p1);
    }

    @Override
    public int compareTo(NodeSection o) {
        if (this.isA != o.isA) {
            if (this.isA) {
                return -1;
            }
            return 1;
        }
        int compDim = Integer.compare(this.dim, o.dim);
        if (compDim != 0) {
            return compDim;
        }
        int compId = Integer.compare(this.id, o.id);
        if (compId != 0) {
            return compId;
        }
        int compRingId = Integer.compare(this.ringId, o.ringId);
        if (compRingId != 0) {
            return compRingId;
        }
        int compV0 = NodeSection.compareWithNull(this.v0, o.v0);
        if (compV0 != 0) {
            return compV0;
        }
        return NodeSection.compareWithNull(this.v1, o.v1);
    }

    private static int compareWithNull(Coordinate v0, Coordinate v1) {
        if (v0 == null) {
            if (v1 == null) {
                return 0;
            }
            return -1;
        }
        if (v1 == null) {
            return 1;
        }
        return v0.compareTo(v1);
    }

    public static class EdgeAngleComparator
    implements Comparator<NodeSection> {
        @Override
        public int compare(NodeSection ns1, NodeSection ns2) {
            return PolygonNodeTopology.compareAngle(ns1.nodePt, ns1.getVertex(0), ns2.getVertex(0));
        }
    }
}

