/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.io.IOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.view.ImmutableViewHistoryEntry;
import org.apache.iceberg.view.ViewHistoryEntry;

class ViewHistoryEntryParser {
    static final String VERSION_ID = "version-id";
    static final String TIMESTAMP_MS = "timestamp-ms";

    private ViewHistoryEntryParser() {
    }

    static String toJson(ViewHistoryEntry entry) {
        return JsonUtil.generate(gen -> ViewHistoryEntryParser.toJson(entry, gen), false);
    }

    static void toJson(ViewHistoryEntry entry, JsonGenerator generator) throws IOException {
        Preconditions.checkArgument(entry != null, "Invalid view history entry: null");
        generator.writeStartObject();
        generator.writeNumberField(TIMESTAMP_MS, entry.timestampMillis());
        generator.writeNumberField(VERSION_ID, entry.versionId());
        generator.writeEndObject();
    }

    static ViewHistoryEntry fromJson(String json) {
        return JsonUtil.parse(json, ViewHistoryEntryParser::fromJson);
    }

    static ViewHistoryEntry fromJson(JsonNode node) {
        Preconditions.checkArgument(node != null, "Cannot parse view history entry from null object");
        Preconditions.checkArgument(node.isObject(), "Cannot parse view history entry from non-object: %s", (Object)node);
        return ImmutableViewHistoryEntry.builder().versionId(JsonUtil.getInt(VERSION_ID, node)).timestampMillis(JsonUtil.getLong(TIMESTAMP_MS, node)).build();
    }
}

