/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.apache.iceberg.view.BaseViewVersion;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.iceberg.view.ViewVersion;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="BaseViewVersion", generator="Immutables")
@Immutable
public final class ImmutableViewVersion
implements BaseViewVersion {
    private final int versionId;
    private final long timestampMillis;
    private final Map<String, String> summary;
    private final List<ViewRepresentation> representations;
    private final int schemaId;
    private final Namespace defaultNamespace;
    @Nullable
    private final String defaultCatalog;
    private volatile transient long lazyInitBitmap;
    private static final long OPERATION_LAZY_INIT_BIT = 1L;
    private transient String operation;

    private ImmutableViewVersion(int versionId, long timestampMillis, Map<String, String> summary, List<ViewRepresentation> representations, int schemaId, Namespace defaultNamespace, @Nullable String defaultCatalog) {
        this.versionId = versionId;
        this.timestampMillis = timestampMillis;
        this.summary = summary;
        this.representations = representations;
        this.schemaId = schemaId;
        this.defaultNamespace = defaultNamespace;
        this.defaultCatalog = defaultCatalog;
    }

    @Override
    public int versionId() {
        return this.versionId;
    }

    @Override
    public long timestampMillis() {
        return this.timestampMillis;
    }

    @Override
    public Map<String, String> summary() {
        return this.summary;
    }

    @Override
    public List<ViewRepresentation> representations() {
        return this.representations;
    }

    @Override
    public int schemaId() {
        return this.schemaId;
    }

    @Override
    public Namespace defaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    @Nullable
    public String defaultCatalog() {
        return this.defaultCatalog;
    }

    public final ImmutableViewVersion withVersionId(int value) {
        if (this.versionId == value) {
            return this;
        }
        return new ImmutableViewVersion(value, this.timestampMillis, this.summary, this.representations, this.schemaId, this.defaultNamespace, this.defaultCatalog);
    }

    public final ImmutableViewVersion withTimestampMillis(long value) {
        if (this.timestampMillis == value) {
            return this;
        }
        return new ImmutableViewVersion(this.versionId, value, this.summary, this.representations, this.schemaId, this.defaultNamespace, this.defaultCatalog);
    }

    public final ImmutableViewVersion withSummary(Map<String, ? extends String> entries) {
        if (this.summary == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableViewVersion.createUnmodifiableMap(true, false, entries);
        return new ImmutableViewVersion(this.versionId, this.timestampMillis, newValue, this.representations, this.schemaId, this.defaultNamespace, this.defaultCatalog);
    }

    public final ImmutableViewVersion withRepresentations(ViewRepresentation ... elements) {
        List<ViewRepresentation> newValue = ImmutableViewVersion.createUnmodifiableList(false, ImmutableViewVersion.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, newValue, this.schemaId, this.defaultNamespace, this.defaultCatalog);
    }

    public final ImmutableViewVersion withRepresentations(Iterable<? extends ViewRepresentation> elements) {
        if (this.representations == elements) {
            return this;
        }
        List<ViewRepresentation> newValue = ImmutableViewVersion.createUnmodifiableList(false, ImmutableViewVersion.createSafeList(elements, true, false));
        return new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, newValue, this.schemaId, this.defaultNamespace, this.defaultCatalog);
    }

    public final ImmutableViewVersion withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, this.representations, value, this.defaultNamespace, this.defaultCatalog);
    }

    public final ImmutableViewVersion withDefaultNamespace(Namespace value) {
        if (this.defaultNamespace == value) {
            return this;
        }
        Namespace newValue = Objects.requireNonNull(value, "defaultNamespace");
        return new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, this.representations, this.schemaId, newValue, this.defaultCatalog);
    }

    public final ImmutableViewVersion withDefaultCatalog(@Nullable String value) {
        if (Objects.equals(this.defaultCatalog, value)) {
            return this;
        }
        return new ImmutableViewVersion(this.versionId, this.timestampMillis, this.summary, this.representations, this.schemaId, this.defaultNamespace, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableViewVersion && this.equalsByValue((ImmutableViewVersion)another);
    }

    private boolean equalsByValue(ImmutableViewVersion another) {
        return this.versionId == another.versionId && this.timestampMillis == another.timestampMillis && this.summary.equals(another.summary) && this.representations.equals(another.representations) && this.schemaId == another.schemaId && this.defaultNamespace.equals(another.defaultNamespace) && Objects.equals(this.defaultCatalog, another.defaultCatalog);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.versionId;
        h2 += (h2 << 5) + Long.hashCode(this.timestampMillis);
        h2 += (h2 << 5) + this.summary.hashCode();
        h2 += (h2 << 5) + this.representations.hashCode();
        h2 += (h2 << 5) + this.schemaId;
        h2 += (h2 << 5) + this.defaultNamespace.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.defaultCatalog);
        return h2;
    }

    public String toString() {
        return "BaseViewVersion{versionId=" + this.versionId + ", timestampMillis=" + this.timestampMillis + ", summary=" + String.valueOf(this.summary) + ", representations=" + String.valueOf(this.representations) + ", schemaId=" + this.schemaId + ", defaultNamespace=" + String.valueOf(this.defaultNamespace) + ", defaultCatalog=" + this.defaultCatalog + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String operation() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableViewVersion immutableViewVersion = this;
            synchronized (immutableViewVersion) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.operation = Objects.requireNonNull(BaseViewVersion.super.operation(), "operation");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.operation;
    }

    static ImmutableViewVersion copyOf(BaseViewVersion instance) {
        if (instance instanceof ImmutableViewVersion) {
            return (ImmutableViewVersion)instance;
        }
        return ImmutableViewVersion.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="BaseViewVersion", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VERSION_ID = 1L;
        private static final long INIT_BIT_TIMESTAMP_MILLIS = 2L;
        private static final long INIT_BIT_SCHEMA_ID = 4L;
        private static final long INIT_BIT_DEFAULT_NAMESPACE = 8L;
        private long initBits = 15L;
        private int versionId;
        private long timestampMillis;
        private Map<String, String> summary = new LinkedHashMap<String, String>();
        private List<ViewRepresentation> representations = new ArrayList<ViewRepresentation>();
        private int schemaId;
        @Nullable
        private Namespace defaultNamespace;
        @Nullable
        private String defaultCatalog;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ImmutableViewVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseViewVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ViewVersion instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            String defaultCatalogValue;
            ViewVersion instance;
            long bits = 0L;
            if (object instanceof BaseViewVersion) {
                instance = (BaseViewVersion)object;
                if ((bits & 1L) == 0L) {
                    this.putAllSummary(instance.summary());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.defaultNamespace(instance.defaultNamespace());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.versionId(instance.versionId());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.timestampMillis(instance.timestampMillis());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.schemaId(instance.schemaId());
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    defaultCatalogValue = instance.defaultCatalog();
                    if (defaultCatalogValue != null) {
                        this.defaultCatalog(defaultCatalogValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllRepresentations(instance.representations());
                    bits |= 8L;
                }
            }
            if (object instanceof ViewVersion) {
                instance = (ViewVersion)object;
                if ((bits & 1L) == 0L) {
                    this.putAllSummary(instance.summary());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.defaultNamespace(instance.defaultNamespace());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.versionId(instance.versionId());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.timestampMillis(instance.timestampMillis());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.schemaId(instance.schemaId());
                    bits |= 0x40L;
                }
                if ((bits & 4L) == 0L) {
                    defaultCatalogValue = instance.defaultCatalog();
                    if (defaultCatalogValue != null) {
                        this.defaultCatalog(defaultCatalogValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.addAllRepresentations(instance.representations());
                    bits |= 8L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder versionId(int versionId) {
            this.versionId = versionId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timestampMillis(long timestampMillis) {
            this.timestampMillis = timestampMillis;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSummary(String key, String value) {
            this.summary.put(Objects.requireNonNull(key, "summary key"), Objects.requireNonNull(value, value == null ? "summary value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putSummary(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.summary.put(Objects.requireNonNull(k, "summary key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "summary value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder summary(Map<String, ? extends String> entries) {
            this.summary.clear();
            return this.putAllSummary(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllSummary(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.summary.put(Objects.requireNonNull(k, "summary key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "summary value for key: " + k : null));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepresentations(ViewRepresentation element) {
            this.representations.add(Objects.requireNonNull(element, "representations element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRepresentations(ViewRepresentation ... elements) {
            for (ViewRepresentation element : elements) {
                this.representations.add(Objects.requireNonNull(element, "representations element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder representations(Iterable<? extends ViewRepresentation> elements) {
            this.representations.clear();
            return this.addAllRepresentations(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRepresentations(Iterable<? extends ViewRepresentation> elements) {
            for (ViewRepresentation viewRepresentation : elements) {
                this.representations.add(Objects.requireNonNull(viewRepresentation, "representations element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultNamespace(Namespace defaultNamespace) {
            this.defaultNamespace = Objects.requireNonNull(defaultNamespace, "defaultNamespace");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultCatalog(@Nullable String defaultCatalog) {
            this.defaultCatalog = defaultCatalog;
            return this;
        }

        public ImmutableViewVersion build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableViewVersion(this.versionId, this.timestampMillis, ImmutableViewVersion.createUnmodifiableMap(false, false, this.summary), ImmutableViewVersion.createUnmodifiableList(true, this.representations), this.schemaId, this.defaultNamespace, this.defaultCatalog);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("versionId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timestampMillis");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("schemaId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("defaultNamespace");
            }
            return "Cannot build BaseViewVersion, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

