/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.variants;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.UUIDUtil;
import org.apache.iceberg.variants.BasicType;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.SerializedValue;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantUtil;

class SerializedPrimitive
implements VariantPrimitive<Object>,
SerializedValue {
    private static final int PRIMITIVE_TYPE_SHIFT = 2;
    private static final int PRIMITIVE_OFFSET = 1;
    private final ByteBuffer value;
    private final PhysicalType type;
    private Object primitive = null;

    static SerializedPrimitive from(byte[] bytes) {
        return SerializedPrimitive.from(ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN), bytes[0]);
    }

    static SerializedPrimitive from(ByteBuffer value, int header) {
        Preconditions.checkArgument(value.order() == ByteOrder.LITTLE_ENDIAN, "Unsupported byte order: big endian");
        BasicType basicType = VariantUtil.basicType(header);
        Preconditions.checkArgument(basicType == BasicType.PRIMITIVE, "Invalid primitive, basic type != PRIMITIVE: " + String.valueOf((Object)basicType));
        return new SerializedPrimitive(value, header);
    }

    private SerializedPrimitive(ByteBuffer value, int header) {
        this.value = value;
        this.type = PhysicalType.from(header >> 2);
    }

    private Object read() {
        switch (this.type) {
            case NULL: {
                return null;
            }
            case BOOLEAN_TRUE: {
                return true;
            }
            case BOOLEAN_FALSE: {
                return false;
            }
            case INT8: {
                return VariantUtil.readLittleEndianInt8(this.value, 1);
            }
            case INT16: {
                return VariantUtil.readLittleEndianInt16(this.value, 1);
            }
            case INT32: 
            case DATE: {
                return VariantUtil.readLittleEndianInt32(this.value, 1);
            }
            case INT64: 
            case TIMESTAMPTZ: 
            case TIMESTAMPNTZ: 
            case TIME: 
            case TIMESTAMPTZ_NANOS: 
            case TIMESTAMPNTZ_NANOS: {
                return VariantUtil.readLittleEndianInt64(this.value, 1);
            }
            case FLOAT: {
                return Float.valueOf(VariantUtil.readFloat(this.value, 1));
            }
            case DOUBLE: {
                return VariantUtil.readDouble(this.value, 1);
            }
            case DECIMAL4: {
                int scale = VariantUtil.readByte(this.value, 1);
                int unscaled = VariantUtil.readLittleEndianInt32(this.value, 2);
                return new BigDecimal(BigInteger.valueOf(unscaled), scale);
            }
            case DECIMAL8: {
                int scale = VariantUtil.readByte(this.value, 1);
                long unscaled = VariantUtil.readLittleEndianInt64(this.value, 2);
                return new BigDecimal(BigInteger.valueOf(unscaled), scale);
            }
            case DECIMAL16: {
                int scale = VariantUtil.readByte(this.value, 1);
                byte[] unscaled = new byte[16];
                for (int i = 0; i < 16; ++i) {
                    unscaled[i] = (byte)VariantUtil.readByte(this.value, 17 - i);
                }
                return new BigDecimal(new BigInteger(unscaled), scale);
            }
            case BINARY: {
                int size = VariantUtil.readLittleEndianInt32(this.value, 1);
                return VariantUtil.slice(this.value, 5, size);
            }
            case STRING: {
                int size = VariantUtil.readLittleEndianInt32(this.value, 1);
                return VariantUtil.readString(this.value, 5, size);
            }
            case UUID: {
                return UUIDUtil.convert(VariantUtil.slice(this.value, 1, 16).order(ByteOrder.BIG_ENDIAN));
            }
        }
        throw new UnsupportedOperationException("Unsupported primitive type: " + String.valueOf((Object)this.type));
    }

    @Override
    public PhysicalType type() {
        return this.type;
    }

    @Override
    public Object get() {
        if (null == this.primitive) {
            this.primitive = this.read();
        }
        return this.primitive;
    }

    @Override
    public ByteBuffer buffer() {
        return this.value;
    }

    public int hashCode() {
        return VariantPrimitive.hash(this);
    }

    public boolean equals(Object other) {
        return VariantPrimitive.equals(this, other);
    }

    public String toString() {
        return VariantPrimitive.asString(this);
    }
}

