/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionUtil.class);

    private ExceptionUtil() {
    }

    public static <E extends Exception> void castAndThrow(Throwable exception, Class<E> exceptionClass) throws E {
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof Error) {
            throw (Error)exception;
        }
        if (exceptionClass.isInstance(exception)) {
            throw (Exception)exception;
        }
        throw new RuntimeException(exception);
    }

    public static <R> R runSafely(Block<R, RuntimeException, RuntimeException, RuntimeException> block, CatchBlock catchBlock, FinallyBlock finallyBlock) {
        return ExceptionUtil.runSafely(block, catchBlock, finallyBlock, RuntimeException.class, RuntimeException.class, RuntimeException.class);
    }

    public static <R, E1 extends Exception> R runSafely(Block<R, E1, RuntimeException, RuntimeException> block, CatchBlock catchBlock, FinallyBlock finallyBlock, Class<? extends E1> e1Class) throws E1 {
        return ExceptionUtil.runSafely(block, catchBlock, finallyBlock, e1Class, RuntimeException.class, RuntimeException.class);
    }

    public static <R, E1 extends Exception, E2 extends Exception> R runSafely(Block<R, E1, E2, RuntimeException> block, CatchBlock catchBlock, FinallyBlock finallyBlock, Class<? extends E1> e1Class, Class<? extends E2> e2Class) throws E1, E2 {
        return ExceptionUtil.runSafely(block, catchBlock, finallyBlock, e1Class, e2Class, RuntimeException.class);
    }

    public static <R, E1 extends Exception, E2 extends Exception, E3 extends Exception> R runSafely(Block<R, E1, E2, E3> block, CatchBlock catchBlock, FinallyBlock finallyBlock, Class<? extends E1> e1Class, Class<? extends E2> e2Class, Class<? extends E3> e3Class) throws E1, E2, E3 {
        Throwable failure = null;
        try {
            R r = block.run();
            return r;
        }
        catch (Throwable t2) {
            failure = t2;
            if (catchBlock != null) {
                try {
                    catchBlock.run(failure);
                }
                catch (Exception e) {
                    LOG.warn("Suppressing failure in catch block", (Throwable)e);
                    failure.addSuppressed(e);
                }
            }
            ExceptionUtil.tryThrowAs(failure, e1Class);
            ExceptionUtil.tryThrowAs(failure, e2Class);
            ExceptionUtil.tryThrowAs(failure, e3Class);
            ExceptionUtil.tryThrowAs(failure, RuntimeException.class);
            throw new RuntimeException("Unknown throwable", failure);
        }
        finally {
            if (finallyBlock != null) {
                try {
                    finallyBlock.run();
                }
                catch (Exception e) {
                    if (failure != null) {
                        LOG.warn("Suppressing failure in finally block", (Throwable)e);
                        failure.addSuppressed(e);
                    }
                    ExceptionUtil.tryThrowAs(e, e1Class);
                    ExceptionUtil.tryThrowAs(e, e2Class);
                    ExceptionUtil.tryThrowAs(e, e3Class);
                    ExceptionUtil.tryThrowAs(e, RuntimeException.class);
                    throw new RuntimeException("Unknown exception in finally block", e);
                }
            }
        }
    }

    private static <E extends Exception> void tryThrowAs(Throwable failure, Class<E> excClass) throws E {
        if (excClass.isInstance(failure)) {
            throw (Exception)excClass.cast(failure);
        }
    }

    public static interface Block<R, E1 extends Exception, E2 extends Exception, E3 extends Exception> {
        public R run() throws E1, E2, E3;
    }

    public static interface CatchBlock {
        public void run(Throwable var1) throws Exception;
    }

    public static interface FinallyBlock {
        public void run() throws Exception;
    }
}

