/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.variant;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import org.apache.iceberg.shaded.org.apache.parquet.Preconditions;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.Binary;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.RecordConsumer;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.shaded.org.apache.parquet.variant.ImmutableMetadata;
import org.apache.iceberg.shaded.org.apache.parquet.variant.Metadata;
import org.apache.iceberg.shaded.org.apache.parquet.variant.Variant;
import org.apache.iceberg.shaded.org.apache.parquet.variant.VariantBuilder;
import org.apache.iceberg.shaded.org.apache.parquet.variant.VariantObjectBuilder;

public class VariantValueWriter {
    private static final String LIST_REPEATED_NAME = "list";
    private static final String LIST_ELEMENT_NAME = "element";
    private final ByteBuffer metadataBuffer;
    private final RecordConsumer recordConsumer;
    private ImmutableMetadata metadata = null;

    VariantValueWriter(RecordConsumer recordConsumer, ByteBuffer metadata) {
        this.recordConsumer = recordConsumer;
        this.metadataBuffer = metadata;
    }

    Metadata getMetadata() {
        if (this.metadata == null) {
            this.metadata = new ImmutableMetadata(this.metadataBuffer);
        }
        return this.metadata;
    }

    public static void write(RecordConsumer recordConsumer, GroupType schema, Variant value) {
        recordConsumer.startGroup();
        int metadataIndex = schema.getFieldIndex("metadata");
        recordConsumer.startField("metadata", metadataIndex);
        recordConsumer.addBinary(Binary.fromConstantByteBuffer(value.getMetadataBuffer()));
        recordConsumer.endField("metadata", metadataIndex);
        VariantValueWriter writer = new VariantValueWriter(recordConsumer, value.getMetadataBuffer());
        writer.write(schema, value);
        recordConsumer.endGroup();
    }

    void write(GroupType schema, Variant value) {
        Variant.Type variantType;
        Type typedValueField = null;
        if (schema.containsField("typed_value")) {
            typedValueField = schema.getType("typed_value");
        }
        if (VariantValueWriter.isTypeCompatible(variantType = value.getType(), typedValueField, value)) {
            int typedValueIdx = schema.getFieldIndex("typed_value");
            this.recordConsumer.startField("typed_value", typedValueIdx);
            ByteBuffer residual = null;
            if (typedValueField.isPrimitive()) {
                this.writeScalarValue(value);
            } else if (typedValueField.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
                this.writeArrayValue(value, typedValueField.asGroupType());
            } else {
                residual = this.writeObjectValue(value, typedValueField.asGroupType());
            }
            this.recordConsumer.endField("typed_value", typedValueIdx);
            if (residual != null) {
                int valueIdx = schema.getFieldIndex("value");
                this.recordConsumer.startField("value", valueIdx);
                this.recordConsumer.addBinary(Binary.fromConstantByteBuffer(residual));
                this.recordConsumer.endField("value", valueIdx);
            }
        } else {
            int valueIdx = schema.getFieldIndex("value");
            this.recordConsumer.startField("value", valueIdx);
            this.recordConsumer.addBinary(Binary.fromReusedByteBuffer(value.getValueBuffer()));
            this.recordConsumer.endField("value", valueIdx);
        }
    }

    private static boolean compatibleDecimalType(Variant value, LogicalTypeAnnotation logicalType) {
        if (!(logicalType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
            return false;
        }
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalType;
        BigDecimal decimal = value.getDecimal();
        return decimal.scale() == decimalType.getScale() && decimal.precision() <= decimalType.getPrecision();
    }

    private static boolean isTypeCompatible(Variant.Type variantType, Type typedValueField, Variant value) {
        if (typedValueField == null) {
            return false;
        }
        if (typedValueField.isPrimitive()) {
            PrimitiveType primitiveType = typedValueField.asPrimitiveType();
            LogicalTypeAnnotation logicalType = primitiveType.getLogicalTypeAnnotation();
            PrimitiveType.PrimitiveTypeName primitiveTypeName = primitiveType.getPrimitiveTypeName();
            switch (variantType) {
                case BOOLEAN: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.BOOLEAN;
                }
                case BYTE: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).isSigned() && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).getBitWidth() == 8;
                }
                case SHORT: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).isSigned() && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).getBitWidth() == 16;
                }
                case INT: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).isSigned() && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).getBitWidth() == 32);
                }
                case LONG: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64 && (logicalType == null || logicalType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).isSigned() && ((LogicalTypeAnnotation.IntLogicalTypeAnnotation)logicalType).getBitWidth() == 64);
                }
                case FLOAT: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.FLOAT;
                }
                case DOUBLE: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.DOUBLE;
                }
                case DECIMAL4: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && VariantValueWriter.compatibleDecimalType(value, logicalType);
                }
                case DECIMAL8: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64 && VariantValueWriter.compatibleDecimalType(value, logicalType);
                }
                case DECIMAL16: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.BINARY && VariantValueWriter.compatibleDecimalType(value, logicalType);
                }
                case DATE: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT32 && logicalType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation;
                }
                case TIME: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64 && logicalType instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation;
                }
                case TIMESTAMP_NTZ: 
                case TIMESTAMP_NANOS_NTZ: 
                case TIMESTAMP_TZ: 
                case TIMESTAMP_NANOS_TZ: {
                    if (primitiveTypeName == PrimitiveType.PrimitiveTypeName.INT64 && logicalType instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation annotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)logicalType;
                        boolean micros = annotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS;
                        boolean nanos = annotation.getUnit() == LogicalTypeAnnotation.TimeUnit.NANOS;
                        boolean adjustedToUTC = annotation.isAdjustedToUTC();
                        return variantType == Variant.Type.TIMESTAMP_TZ && micros && adjustedToUTC || variantType == Variant.Type.TIMESTAMP_NTZ && micros && !adjustedToUTC || variantType == Variant.Type.TIMESTAMP_NANOS_TZ && nanos && adjustedToUTC || variantType == Variant.Type.TIMESTAMP_NANOS_NTZ && nanos && !adjustedToUTC;
                    }
                    return false;
                }
                case STRING: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.BINARY && logicalType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation;
                }
                case BINARY: {
                    return primitiveTypeName == PrimitiveType.PrimitiveTypeName.BINARY && logicalType == null;
                }
            }
            return false;
        }
        if (typedValueField.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            return variantType == Variant.Type.ARRAY;
        }
        return variantType == Variant.Type.OBJECT;
    }

    private void writeScalarValue(Variant variant) {
        switch (variant.getType()) {
            case BOOLEAN: {
                this.recordConsumer.addBoolean(variant.getBoolean());
                break;
            }
            case BYTE: {
                this.recordConsumer.addInteger(variant.getByte());
                break;
            }
            case SHORT: {
                this.recordConsumer.addInteger(variant.getShort());
                break;
            }
            case INT: {
                this.recordConsumer.addInteger(variant.getInt());
                break;
            }
            case LONG: {
                this.recordConsumer.addLong(variant.getLong());
                break;
            }
            case FLOAT: {
                this.recordConsumer.addFloat(variant.getFloat());
                break;
            }
            case DOUBLE: {
                this.recordConsumer.addDouble(variant.getDouble());
                break;
            }
            case DECIMAL4: {
                this.recordConsumer.addInteger(variant.getDecimal().unscaledValue().intValue());
                break;
            }
            case DECIMAL8: {
                this.recordConsumer.addLong(variant.getDecimal().unscaledValue().longValue());
                break;
            }
            case DECIMAL16: {
                this.recordConsumer.addBinary(Binary.fromConstantByteArray(variant.getDecimal().unscaledValue().toByteArray()));
                break;
            }
            case DATE: {
                this.recordConsumer.addInteger(variant.getInt());
                break;
            }
            case TIME: {
                this.recordConsumer.addLong(variant.getLong());
                break;
            }
            case TIMESTAMP_TZ: {
                this.recordConsumer.addLong(variant.getLong());
                break;
            }
            case TIMESTAMP_NTZ: {
                this.recordConsumer.addLong(variant.getLong());
                break;
            }
            case TIMESTAMP_NANOS_TZ: {
                this.recordConsumer.addLong(variant.getLong());
                break;
            }
            case TIMESTAMP_NANOS_NTZ: {
                this.recordConsumer.addLong(variant.getLong());
                break;
            }
            case STRING: {
                this.recordConsumer.addBinary(Binary.fromString(variant.getString()));
                break;
            }
            case BINARY: {
                this.recordConsumer.addBinary(Binary.fromReusedByteBuffer(variant.getBinary()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported scalar type: " + (Object)((Object)variant.getType()));
            }
        }
    }

    private void writeArrayValue(Variant variant, GroupType arrayType) {
        Preconditions.checkArgument(variant.getType() == Variant.Type.ARRAY, "Cannot write variant type " + (Object)((Object)variant.getType()) + " as array");
        if (arrayType.getFieldCount() != 1 || arrayType.getRepetition() == Type.Repetition.REPEATED || arrayType.getType(0).isPrimitive() || !arrayType.getFieldName(0).equals(LIST_REPEATED_NAME)) {
            throw new IllegalArgumentException("Variant list must be a three-level list structure: " + arrayType);
        }
        GroupType repeatedType = arrayType.getType(0).asGroupType();
        if (repeatedType.getFieldCount() != 1 || repeatedType.getRepetition() != Type.Repetition.REPEATED || repeatedType.getType(0).isPrimitive() || !repeatedType.getFieldName(0).equals(LIST_ELEMENT_NAME)) {
            throw new IllegalArgumentException("Variant list must be a three-level list structure: " + arrayType);
        }
        GroupType elementType = repeatedType.getType(0).asGroupType();
        this.recordConsumer.startGroup();
        int numElements = variant.numArrayElements();
        if (numElements > 0) {
            this.recordConsumer.startField(LIST_REPEATED_NAME, 0);
            for (int i = 0; i < numElements; ++i) {
                this.recordConsumer.startGroup();
                this.recordConsumer.startField(LIST_ELEMENT_NAME, 0);
                this.recordConsumer.startGroup();
                this.write(elementType, variant.getElementAtIndex(i));
                this.recordConsumer.endGroup();
                this.recordConsumer.endField(LIST_ELEMENT_NAME, 0);
                this.recordConsumer.endGroup();
            }
            this.recordConsumer.endField(LIST_REPEATED_NAME, 0);
        }
        this.recordConsumer.endGroup();
    }

    private ByteBuffer writeObjectValue(Variant variant, GroupType objectType) {
        Preconditions.checkArgument(variant.getType() == Variant.Type.OBJECT, "Cannot write variant type " + (Object)((Object)variant.getType()) + " as object");
        VariantBuilder residualBuilder = null;
        VariantObjectBuilder objectBuilder = null;
        this.recordConsumer.startGroup();
        for (int i = 0; i < variant.numObjectElements(); ++i) {
            Variant.ObjectField field = variant.getFieldAtIndex(i);
            if (objectType.containsField(field.key)) {
                int fieldIndex = objectType.getFieldIndex(field.key);
                Type fieldType = objectType.getType(fieldIndex);
                this.recordConsumer.startField(field.key, fieldIndex);
                this.recordConsumer.startGroup();
                this.write(fieldType.asGroupType(), field.value);
                this.recordConsumer.endGroup();
                this.recordConsumer.endField(field.key, objectType.getFieldIndex(field.key));
                continue;
            }
            if (residualBuilder == null) {
                residualBuilder = new VariantBuilder(this.getMetadata());
                objectBuilder = residualBuilder.startObject();
            }
            objectBuilder.appendKey(field.key);
            objectBuilder.appendEncodedValue(field.value.getValueBuffer());
        }
        this.recordConsumer.endGroup();
        if (residualBuilder != null) {
            residualBuilder.endObject();
            return residualBuilder.build().getValueBuffer();
        }
        return null;
    }
}

