/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.variant;

import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.iceberg.shaded.org.apache.parquet.variant.Metadata;
import org.apache.iceberg.shaded.org.apache.parquet.variant.VariantUtil;

public class ImmutableMetadata
implements Metadata {
    private final HashMap<String, Integer> dictionary;
    private final ByteBuffer metadataBuffer;

    public ImmutableMetadata(ByteBuffer metadata) {
        this.dictionary = VariantUtil.getMetadataMap(metadata);
        this.metadataBuffer = metadata;
    }

    @Override
    public int getOrInsert(String key) {
        Integer result = this.dictionary.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Key does not exist in metadata: " + key);
        }
        return result;
    }

    @Override
    public ByteBuffer getEncodedBuffer() {
        return this.metadataBuffer;
    }
}

