/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate;

import java.util.Objects;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.Operators;
import org.apache.iceberg.shaded.org.apache.parquet.filter2.predicate.UserDefinedPredicate;

public final class LogicalInverter
implements FilterPredicate.Visitor<FilterPredicate> {
    private static final LogicalInverter INSTANCE = new LogicalInverter();

    public static FilterPredicate invert(FilterPredicate pred) {
        Objects.requireNonNull(pred, "pred cannot be null");
        return pred.accept(INSTANCE);
    }

    private LogicalInverter() {
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Eq<T> eq) {
        return new Operators.NotEq<Comparable>(eq.getColumn(), eq.getValue());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.NotEq<T> notEq) {
        return new Operators.Eq<Comparable>(notEq.getColumn(), notEq.getValue());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Lt<T> lt) {
        return new Operators.GtEq<Comparable>(lt.getColumn(), lt.getValue());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.LtEq<T> ltEq) {
        return new Operators.Gt<Comparable>(ltEq.getColumn(), ltEq.getValue());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Gt<T> gt) {
        return new Operators.LtEq<Comparable>(gt.getColumn(), gt.getValue());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.GtEq<T> gtEq) {
        return new Operators.Lt<Comparable>(gtEq.getColumn(), gtEq.getValue());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.In<T> in) {
        return new Operators.NotIn(in.getColumn(), in.getValues());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.NotIn<T> notIn) {
        return new Operators.In(notIn.getColumn(), notIn.getValues());
    }

    @Override
    public <T extends Comparable<T>> FilterPredicate visit(Operators.Contains<T> contains) {
        return contains.not();
    }

    @Override
    public FilterPredicate visit(Operators.And and) {
        return new Operators.Or(and.getLeft().accept(this), and.getRight().accept(this));
    }

    @Override
    public FilterPredicate visit(Operators.Or or) {
        return new Operators.And(or.getLeft().accept(this), or.getRight().accept(this));
    }

    @Override
    public FilterPredicate visit(Operators.Not not) {
        return not.getPredicate();
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> FilterPredicate visit(Operators.UserDefined<T, U> udp) {
        return new Operators.LogicalNotUserDefined<T, U>(udp);
    }

    @Override
    public <T extends Comparable<T>, U extends UserDefinedPredicate<T>> FilterPredicate visit(Operators.LogicalNotUserDefined<T, U> udp) {
        return udp.getUserDefined();
    }
}

