/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.crypto;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.apache.iceberg.shaded.org.apache.parquet.bytes.BytesUtils;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.AesCipher;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.AesMode;
import org.apache.iceberg.shaded.org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.iceberg.shaded.org.apache.parquet.format.BlockCipher;

public class AesCtrEncryptor
extends AesCipher
implements BlockCipher.Encryptor {
    private final byte[] ctrIV;
    private long operationCounter = 0L;

    AesCtrEncryptor(byte[] keyBytes) {
        super(AesMode.CTR, keyBytes);
        try {
            this.cipher = Cipher.getInstance(AesMode.CTR.getCipherName());
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to create CTR cipher", e);
        }
        this.ctrIV = new byte[16];
        this.ctrIV[15] = 1;
    }

    @Override
    public byte[] encrypt(byte[] plainText, byte[] AAD) {
        return this.encrypt(true, plainText, AAD);
    }

    public byte[] encrypt(boolean writeLength, byte[] plainText, byte[] AAD) {
        this.randomGenerator.nextBytes(this.localNonce);
        return this.encrypt(writeLength, plainText, this.localNonce, AAD);
    }

    public byte[] encrypt(boolean writeLength, byte[] plainText, byte[] nonce, byte[] AAD) {
        if (this.operationCounter > 0x100000000L) {
            throw new ParquetCryptoRuntimeException("Exceeded limit of AES CTR encryption operations with same key and random IV");
        }
        ++this.operationCounter;
        if (nonce.length != 12) {
            throw new ParquetCryptoRuntimeException("Wrong nonce length " + nonce.length);
        }
        int plainTextLength = plainText.length;
        int cipherTextLength = 12 + plainTextLength;
        int lengthBufferLength = writeLength ? 4 : 0;
        byte[] cipherText = new byte[lengthBufferLength + cipherTextLength];
        int inputOffset = 0;
        int outputOffset = lengthBufferLength + 12;
        try {
            int inputLength;
            System.arraycopy(nonce, 0, this.ctrIV, 0, 12);
            IvParameterSpec spec = new IvParameterSpec(this.ctrIV);
            this.cipher.init(1, (Key)this.aesKey, spec);
            for (inputLength = plainTextLength; inputLength > 4096; inputLength -= 4096) {
                int written = this.cipher.update(plainText, inputOffset, 4096, cipherText, outputOffset);
                inputOffset += 4096;
                outputOffset += written;
            }
            this.cipher.doFinal(plainText, inputOffset, inputLength, cipherText, outputOffset);
        }
        catch (GeneralSecurityException e) {
            throw new ParquetCryptoRuntimeException("Failed to encrypt", e);
        }
        if (writeLength) {
            System.arraycopy(BytesUtils.intToBytes(cipherTextLength), 0, cipherText, 0, lengthBufferLength);
        }
        System.arraycopy(nonce, 0, cipherText, lengthBufferLength, 12);
        return cipherText;
    }
}

