/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.avro;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.shaded.org.apache.parquet.avro.AvroConverters;

abstract class ReflectClassValidator {
    ReflectClassValidator() {
    }

    abstract void validate(String var1);

    private static void forbiddenClass(String className) {
        throw new SecurityException("Forbidden " + className + "! This class is not trusted to be included in Avro schema using java-class or java-key-class. Please set the Parquet/Hadoop configuration parquet.avro.serializable.classes with the classes you trust.");
    }

    static class ClassValidator
    extends ReflectClassValidator {
        private final Set<String> trustedClassNames = new HashSet<String>();

        ClassValidator(String ... classNames) {
            for (String className : classNames) {
                this.addTrustedClassName(className);
            }
        }

        void addTrustedClassName(String className) {
            this.trustedClassNames.add(className);
        }

        @Override
        void validate(String className) {
            if (!this.trustedClassNames.contains(className)) {
                ReflectClassValidator.forbiddenClass(className);
            }
        }
    }

    static class PackageValidator
    extends ReflectClassValidator {
        private final List<String> trustedPackagePrefixes = Stream.of(AvroConverters.SERIALIZABLE_PACKAGES).map(p -> p.endsWith(".") ? p : p + ".").collect(Collectors.toList());
        private final boolean trustAllPackages = this.trustedPackagePrefixes.size() == 1 && "*".equals(this.trustedPackagePrefixes.get(0));
        private static final Set<String> PRIMITIVES = new HashSet<String>(Arrays.asList(Boolean.TYPE.getName(), Character.TYPE.getName(), Byte.TYPE.getName(), Short.TYPE.getName(), Integer.TYPE.getName(), Long.TYPE.getName(), Float.TYPE.getName(), Double.TYPE.getName(), Void.TYPE.getName()));

        PackageValidator() {
        }

        @Override
        public void validate(String className) {
            if (this.trustAllPackages || PRIMITIVES.contains(className)) {
                return;
            }
            for (String packagePrefix : this.trustedPackagePrefixes) {
                if (!className.startsWith(packagePrefix)) continue;
                return;
            }
            ReflectClassValidator.forbiddenClass(className);
        }
    }
}

