/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl.writer;

import java.io.IOException;
import java.util.function.Consumer;
import org.apache.iceberg.shaded.org.apache.orc.OrcProto;
import org.apache.iceberg.shaded.org.apache.orc.TypeDescription;
import org.apache.iceberg.shaded.org.apache.orc.impl.CryptoUtils;
import org.apache.iceberg.shaded.org.apache.orc.impl.IntegerWriter;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionRecorder;
import org.apache.iceberg.shaded.org.apache.orc.impl.PositionedOutputStream;
import org.apache.iceberg.shaded.org.apache.orc.impl.SerializationUtils;
import org.apache.iceberg.shaded.org.apache.orc.impl.StreamName;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.WriterContext;
import org.apache.iceberg.shaded.org.apache.orc.impl.writer.WriterEncryptionVariant;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.Decimal64ColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.iceberg.shaded.org.apache.orc.storage.ql.util.JavaDataModel;
import org.apache.iceberg.shaded.org.apache.orc.storage.serde2.io.HiveDecimalWritable;

public class DecimalTreeWriter
extends TreeWriterBase {
    private final PositionedOutputStream valueStream;
    private final SerializationUtils utils = new SerializationUtils();
    private final long[] scratchLongs;
    private final byte[] scratchBuffer;
    private final IntegerWriter scaleStream;
    private final boolean isDirectV2;

    public DecimalTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext context) throws IOException {
        super(schema, encryption, context);
        this.isDirectV2 = this.isNewWriteFormat(context);
        this.valueStream = context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption));
        this.scratchLongs = new long[6];
        this.scratchBuffer = new byte[79];
        this.scaleStream = this.createIntegerWriter(context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.SECONDARY, encryption)), true, this.isDirectV2, context);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    private void writeBatch(DecimalColumnVector vector, int offset, int length) throws IOException {
        block6: {
            block5: {
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                HiveDecimalWritable value = vector.vector[0];
                this.indexStatistics.updateDecimal(value);
                if (this.createBloomFilter) {
                    String str = value.toString(this.scratchBuffer);
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addString(str);
                    }
                    this.bloomFilterUtf8.addString(str);
                }
                for (int i = 0; i < length; ++i) {
                    value.serializationUtilsWrite(this.valueStream, this.scratchLongs);
                    this.scaleStream.write(value.scale());
                }
                break block6;
            }
            for (int i = 0; i < length; ++i) {
                if (!vector.noNulls && vector.isNull[i + offset]) continue;
                HiveDecimalWritable value = vector.vector[i + offset];
                value.serializationUtilsWrite(this.valueStream, this.scratchLongs);
                this.scaleStream.write(value.scale());
                this.indexStatistics.updateDecimal(value);
                if (!this.createBloomFilter) continue;
                String str = value.toString(this.scratchBuffer);
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(str);
                }
                this.bloomFilterUtf8.addString(str);
            }
        }
    }

    private void writeBatch(Decimal64ColumnVector vector, int offset, int length) throws IOException {
        block6: {
            block5: {
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                this.indexStatistics.updateDecimal64(vector.vector[0], vector.scale);
                if (this.createBloomFilter) {
                    HiveDecimalWritable value = vector.getScratchWritable();
                    value.setFromLongAndScale(vector.vector[0], vector.scale);
                    String str = value.toString(this.scratchBuffer);
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addString(str);
                    }
                    this.bloomFilterUtf8.addString(str);
                }
                for (int i = 0; i < length; ++i) {
                    this.utils.writeVslong(this.valueStream, vector.vector[0]);
                    this.scaleStream.write(vector.scale);
                }
                break block6;
            }
            HiveDecimalWritable value = vector.getScratchWritable();
            for (int i = 0; i < length; ++i) {
                if (!vector.noNulls && vector.isNull[i + offset]) continue;
                long num = vector.vector[i + offset];
                this.utils.writeVslong(this.valueStream, num);
                this.scaleStream.write(vector.scale);
                this.indexStatistics.updateDecimal64(num, vector.scale);
                if (!this.createBloomFilter) continue;
                value.setFromLongAndScale(num, vector.scale);
                String str = value.toString(this.scratchBuffer);
                if (this.bloomFilter != null) {
                    this.bloomFilter.addString(str);
                }
                this.bloomFilterUtf8.addString(str);
            }
        }
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        super.writeBatch(vector, offset, length);
        if (vector instanceof Decimal64ColumnVector) {
            this.writeBatch((Decimal64ColumnVector)vector, offset, length);
        } else {
            this.writeBatch((DecimalColumnVector)vector, offset, length);
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        super.writeStripe(requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.valueStream.getPosition(recorder);
        this.scaleStream.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.valueStream.getBufferSize() + this.scaleStream.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        return this.fileStatistics.getNumberOfValues() * (long)JavaDataModel.get().lengthOfDecimal();
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.valueStream.flush();
        this.scaleStream.flush();
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        Consumer<byte[]> updater = CryptoUtils.modifyIvForStripe(stripeId);
        this.valueStream.changeIv(updater);
        this.scaleStream.changeIv(updater);
    }
}

