/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.hc.client5.http.psl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.psl.DomainType;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.psl.PublicSuffixList;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.Contract;
import org.apache.iceberg.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.iceberg.shaded.org.apache.hc.core5.util.Args;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE)
public final class PublicSuffixMatcherLoader {
    private static final String PUBLIC_SUFFIX_LIST = "/org/publicsuffix/list/effective_tld_names.dat";
    private static final Logger LOG = LoggerFactory.getLogger(PublicSuffixMatcherLoader.class);
    private static final ReentrantLock lock = new ReentrantLock();
    private static volatile PublicSuffixMatcher DEFAULT_INSTANCE;

    private static PublicSuffixMatcher load(InputStream in) throws IOException {
        List<PublicSuffixList> lists = PublicSuffixListParser.INSTANCE.parseByType(new InputStreamReader(in, StandardCharsets.UTF_8));
        return new PublicSuffixMatcher(lists);
    }

    public static PublicSuffixMatcher load(URL url) throws IOException {
        Args.notNull(url, "URL");
        try (InputStream in = url.openStream();){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(in);
            return publicSuffixMatcher;
        }
    }

    public static PublicSuffixMatcher load(File file) throws IOException {
        Args.notNull(file, "File");
        try (FileInputStream in = new FileInputStream(file);){
            PublicSuffixMatcher publicSuffixMatcher = PublicSuffixMatcherLoader.load(in);
            return publicSuffixMatcher;
        }
    }

    public static PublicSuffixMatcher getDefault() {
        if (DEFAULT_INSTANCE == null) {
            lock.lock();
            try {
                if (DEFAULT_INSTANCE == null) {
                    URL url = PublicSuffixMatcherLoader.class.getResource(PUBLIC_SUFFIX_LIST);
                    if (url != null) {
                        try {
                            DEFAULT_INSTANCE = PublicSuffixMatcherLoader.load(url);
                        }
                        catch (IOException ex) {
                            LOG.warn("Failure loading public suffix list from default resource", (Throwable)ex);
                        }
                    } else {
                        DEFAULT_INSTANCE = new PublicSuffixMatcher(DomainType.ICANN, Collections.singletonList("com"), null);
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
        return DEFAULT_INSTANCE;
    }
}

