/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache;

import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.AccessOrderDeque;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.CacheLoader;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Expiry;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Node;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Pacer;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Scheduler;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.Ticker;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.TimerWheel;
import org.apache.iceberg.shaded.com.github.benmanes.caffeine.cache.WSLS;

class WSLSA<K, V>
extends WSLS<K, V> {
    final Ticker ticker;
    final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque;
    final Expiry<K, V> expiry;
    final TimerWheel<K, V> timerWheel;
    volatile long expiresAfterAccessNanos;
    final Pacer pacer;

    WSLSA(Caffeine<K, V> builder, CacheLoader<? super K, V> cacheLoader, boolean async) {
        super(builder, cacheLoader, async);
        this.ticker = builder.getTicker();
        this.accessOrderWindowDeque = builder.evicts() || builder.expiresAfterAccess() ? new AccessOrderDeque() : null;
        this.expiry = builder.getExpiry(this.isAsync);
        this.timerWheel = builder.expiresVariable() ? new TimerWheel(this) : null;
        this.expiresAfterAccessNanos = builder.getExpiresAfterAccessNanos();
        this.pacer = builder.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(builder.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final AccessOrderDeque<Node<K, V>> accessOrderWindowDeque() {
        return this.accessOrderWindowDeque;
    }

    @Override
    protected final boolean expiresVariable() {
        return this.timerWheel != null;
    }

    @Override
    protected final Expiry<K, V> expiry() {
        return this.expiry;
    }

    @Override
    protected final TimerWheel<K, V> timerWheel() {
        return this.timerWheel;
    }

    @Override
    protected final boolean expiresAfterAccess() {
        return this.timerWheel == null;
    }

    @Override
    protected final long expiresAfterAccessNanos() {
        return this.expiresAfterAccessNanos;
    }

    @Override
    protected final void setExpiresAfterAccessNanos(long expiresAfterAccessNanos) {
        this.expiresAfterAccessNanos = expiresAfterAccessNanos;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

