/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.util.List;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.RESTRequest;

public class PlanTableScanRequest
implements RESTRequest {
    private final Long snapshotId;
    private final List<String> select;
    private final Expression filter;
    private final boolean caseSensitive;
    private final boolean useSnapshotSchema;
    private final Long startSnapshotId;
    private final Long endSnapshotId;
    private final List<String> statsFields;

    public Long snapshotId() {
        return this.snapshotId;
    }

    public List<String> select() {
        return this.select;
    }

    public Expression filter() {
        return this.filter;
    }

    public boolean caseSensitive() {
        return this.caseSensitive;
    }

    public boolean useSnapshotSchema() {
        return this.useSnapshotSchema;
    }

    public Long startSnapshotId() {
        return this.startSnapshotId;
    }

    public Long endSnapshotId() {
        return this.endSnapshotId;
    }

    public List<String> statsFields() {
        return this.statsFields;
    }

    private PlanTableScanRequest(Long snapshotId, List<String> select, Expression filter, boolean caseSensitive, boolean useSnapshotSchema, Long startSnapshotId, Long endSnapshotId, List<String> statsFields) {
        this.snapshotId = snapshotId;
        this.select = select;
        this.filter = filter;
        this.caseSensitive = caseSensitive;
        this.useSnapshotSchema = useSnapshotSchema;
        this.startSnapshotId = startSnapshotId;
        this.endSnapshotId = endSnapshotId;
        this.statsFields = statsFields;
        this.validate();
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.snapshotId != null ^ (this.startSnapshotId != null && this.endSnapshotId != null), "Either snapshotId must be provided or both startSnapshotId and endSnapshotId must be provided");
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("snapshotId", this.snapshotId).add("select", this.select).add("filter", this.filter).add("caseSensitive", this.caseSensitive).add("useSnapshotSchema", this.useSnapshotSchema).add("startSnapshotId", this.startSnapshotId).add("endSnapshotId", this.endSnapshotId).add("statsFields", this.statsFields).toString();
    }

    public static class Builder {
        private Long snapshotId;
        private List<String> select;
        private Expression filter;
        private boolean caseSensitive = true;
        private boolean useSnapshotSchema = false;
        private Long startSnapshotId;
        private Long endSnapshotId;
        private List<String> statsFields;

        public Builder withSnapshotId(Long withSnapshotId) {
            this.snapshotId = withSnapshotId;
            return this;
        }

        public Builder withSelect(List<String> projection) {
            this.select = projection;
            return this;
        }

        public Builder withFilter(Expression expression) {
            this.filter = expression;
            return this;
        }

        public Builder withCaseSensitive(boolean value) {
            this.caseSensitive = value;
            return this;
        }

        public Builder withUseSnapshotSchema(boolean snapshotSchema) {
            this.useSnapshotSchema = snapshotSchema;
            return this;
        }

        public Builder withStartSnapshotId(Long startingSnapshotId) {
            this.startSnapshotId = startingSnapshotId;
            return this;
        }

        public Builder withEndSnapshotId(Long endingSnapshotId) {
            this.endSnapshotId = endingSnapshotId;
            return this;
        }

        public Builder withStatsFields(List<String> fields) {
            this.statsFields = fields;
            return this;
        }

        public PlanTableScanRequest build() {
            return new PlanTableScanRequest(this.snapshotId, this.select, this.filter, this.caseSensitive, this.useSnapshotSchema, this.startSnapshotId, this.endSnapshotId, this.statsFields);
        }
    }
}

