/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.auth.AuthConfig;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AuthConfig", generator="Immutables")
@Immutable
public final class ImmutableAuthConfig
implements AuthConfig {
    @Nullable
    private final String token;
    @Nullable
    private final String tokenType;
    @Nullable
    private final String credential;
    private final String scope;
    @Nullable
    private final Long expiresAtMillis;
    private final boolean keepRefreshed;
    private final boolean exchangeEnabled;
    @Nullable
    private final String oauth2ServerUri;
    private final Map<String, String> optionalOAuthParams;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAuthConfig(Builder builder) {
        this.token = builder.token;
        this.tokenType = builder.tokenType;
        this.credential = builder.credential;
        this.optionalOAuthParams = ImmutableAuthConfig.createUnmodifiableMap(false, false, builder.optionalOAuthParams);
        if (builder.scope != null) {
            this.initShim.scope(builder.scope);
        }
        if (builder.expiresAtMillisIsSet()) {
            this.initShim.expiresAtMillis(builder.expiresAtMillis);
        }
        if (builder.keepRefreshedIsSet()) {
            this.initShim.keepRefreshed(builder.keepRefreshed);
        }
        if (builder.exchangeEnabledIsSet()) {
            this.initShim.exchangeEnabled(builder.exchangeEnabled);
        }
        if (builder.oauth2ServerUriIsSet()) {
            this.initShim.oauth2ServerUri(builder.oauth2ServerUri);
        }
        this.scope = this.initShim.scope();
        this.expiresAtMillis = this.initShim.expiresAtMillis();
        this.keepRefreshed = this.initShim.keepRefreshed();
        this.exchangeEnabled = this.initShim.exchangeEnabled();
        this.oauth2ServerUri = this.initShim.oauth2ServerUri();
        this.initShim = null;
    }

    private ImmutableAuthConfig(@Nullable String token, @Nullable String tokenType, @Nullable String credential, String scope, @Nullable Long expiresAtMillis, boolean keepRefreshed, boolean exchangeEnabled, @Nullable String oauth2ServerUri, Map<String, String> optionalOAuthParams) {
        this.token = token;
        this.tokenType = tokenType;
        this.credential = credential;
        this.scope = scope;
        this.expiresAtMillis = expiresAtMillis;
        this.keepRefreshed = keepRefreshed;
        this.exchangeEnabled = exchangeEnabled;
        this.oauth2ServerUri = oauth2ServerUri;
        this.optionalOAuthParams = optionalOAuthParams;
        this.initShim = null;
    }

    private String scopeInitialize() {
        return AuthConfig.super.scope();
    }

    @Nullable
    private Long expiresAtMillisInitialize() {
        return AuthConfig.super.expiresAtMillis();
    }

    private boolean keepRefreshedInitialize() {
        return AuthConfig.super.keepRefreshed();
    }

    private boolean exchangeEnabledInitialize() {
        return AuthConfig.super.exchangeEnabled();
    }

    @Nullable
    private String oauth2ServerUriInitialize() {
        return AuthConfig.super.oauth2ServerUri();
    }

    @Override
    @Nullable
    public String token() {
        return this.token;
    }

    @Override
    @Nullable
    public String tokenType() {
        return this.tokenType;
    }

    @Override
    @Nullable
    public String credential() {
        return this.credential;
    }

    @Override
    public String scope() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scope() : this.scope;
    }

    @Override
    @Nullable
    public Long expiresAtMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.expiresAtMillis() : this.expiresAtMillis;
    }

    @Override
    public boolean keepRefreshed() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keepRefreshed() : this.keepRefreshed;
    }

    @Override
    public boolean exchangeEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.exchangeEnabled() : this.exchangeEnabled;
    }

    @Override
    @Nullable
    public String oauth2ServerUri() {
        InitShim shim = this.initShim;
        return shim != null ? shim.oauth2ServerUri() : this.oauth2ServerUri;
    }

    @Override
    public Map<String, String> optionalOAuthParams() {
        return this.optionalOAuthParams;
    }

    public final ImmutableAuthConfig withToken(@Nullable String value) {
        if (Objects.equals(this.token, value)) {
            return this;
        }
        return new ImmutableAuthConfig(value, this.tokenType, this.credential, this.scope, this.expiresAtMillis, this.keepRefreshed, this.exchangeEnabled, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withTokenType(@Nullable String value) {
        if (Objects.equals(this.tokenType, value)) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, value, this.credential, this.scope, this.expiresAtMillis, this.keepRefreshed, this.exchangeEnabled, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withCredential(@Nullable String value) {
        if (Objects.equals(this.credential, value)) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, this.tokenType, value, this.scope, this.expiresAtMillis, this.keepRefreshed, this.exchangeEnabled, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, this.tokenType, this.credential, newValue, this.expiresAtMillis, this.keepRefreshed, this.exchangeEnabled, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withExpiresAtMillis(@Nullable Long value) {
        if (Objects.equals(this.expiresAtMillis, value)) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, this.tokenType, this.credential, this.scope, value, this.keepRefreshed, this.exchangeEnabled, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withKeepRefreshed(boolean value) {
        if (this.keepRefreshed == value) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, this.tokenType, this.credential, this.scope, this.expiresAtMillis, value, this.exchangeEnabled, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withExchangeEnabled(boolean value) {
        if (this.exchangeEnabled == value) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, this.tokenType, this.credential, this.scope, this.expiresAtMillis, this.keepRefreshed, value, this.oauth2ServerUri, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withOauth2ServerUri(@Nullable String value) {
        if (Objects.equals(this.oauth2ServerUri, value)) {
            return this;
        }
        return new ImmutableAuthConfig(this.token, this.tokenType, this.credential, this.scope, this.expiresAtMillis, this.keepRefreshed, this.exchangeEnabled, value, this.optionalOAuthParams);
    }

    public final ImmutableAuthConfig withOptionalOAuthParams(Map<String, ? extends String> entries) {
        if (this.optionalOAuthParams == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableAuthConfig.createUnmodifiableMap(true, false, entries);
        return new ImmutableAuthConfig(this.token, this.tokenType, this.credential, this.scope, this.expiresAtMillis, this.keepRefreshed, this.exchangeEnabled, this.oauth2ServerUri, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthConfig && this.equalsByValue((ImmutableAuthConfig)another);
    }

    private boolean equalsByValue(ImmutableAuthConfig another) {
        return Objects.equals(this.token, another.token) && Objects.equals(this.tokenType, another.tokenType) && Objects.equals(this.credential, another.credential) && this.scope.equals(another.scope) && Objects.equals(this.expiresAtMillis, another.expiresAtMillis) && this.keepRefreshed == another.keepRefreshed && this.exchangeEnabled == another.exchangeEnabled && Objects.equals(this.oauth2ServerUri, another.oauth2ServerUri) && this.optionalOAuthParams.equals(another.optionalOAuthParams);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.token);
        h2 += (h2 << 5) + Objects.hashCode(this.tokenType);
        h2 += (h2 << 5) + Objects.hashCode(this.credential);
        h2 += (h2 << 5) + this.scope.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.expiresAtMillis);
        h2 += (h2 << 5) + Boolean.hashCode(this.keepRefreshed);
        h2 += (h2 << 5) + Boolean.hashCode(this.exchangeEnabled);
        h2 += (h2 << 5) + Objects.hashCode(this.oauth2ServerUri);
        h2 += (h2 << 5) + this.optionalOAuthParams.hashCode();
        return h2;
    }

    public String toString() {
        return "AuthConfig{token=****, tokenType=" + this.tokenType + ", credential=****, scope=" + this.scope + ", expiresAtMillis=" + this.expiresAtMillis + ", keepRefreshed=" + this.keepRefreshed + ", exchangeEnabled=" + this.exchangeEnabled + ", oauth2ServerUri=" + this.oauth2ServerUri + ", optionalOAuthParams=" + String.valueOf(this.optionalOAuthParams) + "}";
    }

    public static ImmutableAuthConfig copyOf(AuthConfig instance) {
        if (instance instanceof ImmutableAuthConfig) {
            return (ImmutableAuthConfig)instance;
        }
        return ImmutableAuthConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="AuthConfig", generator="Immutables")
    private final class InitShim {
        private byte scopeBuildStage = 0;
        private String scope;
        private byte expiresAtMillisBuildStage = 0;
        private Long expiresAtMillis;
        private byte keepRefreshedBuildStage = 0;
        private boolean keepRefreshed;
        private byte exchangeEnabledBuildStage = 0;
        private boolean exchangeEnabled;
        private byte oauth2ServerUriBuildStage = 0;
        private String oauth2ServerUri;

        private InitShim() {
        }

        String scope() {
            if (this.scopeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scopeBuildStage == 0) {
                this.scopeBuildStage = (byte)-1;
                String computedValue = ImmutableAuthConfig.this.scopeInitialize();
                this.scope = Objects.requireNonNull(computedValue, "scope");
                this.scopeBuildStage = 1;
            }
            return this.scope;
        }

        void scope(String scope) {
            this.scope = scope;
            this.scopeBuildStage = 1;
        }

        Long expiresAtMillis() {
            if (this.expiresAtMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.expiresAtMillisBuildStage == 0) {
                Long computedValue;
                this.expiresAtMillisBuildStage = (byte)-1;
                this.expiresAtMillis = computedValue = ImmutableAuthConfig.this.expiresAtMillisInitialize();
                this.expiresAtMillisBuildStage = 1;
            }
            return this.expiresAtMillis;
        }

        void expiresAtMillis(Long expiresAtMillis) {
            this.expiresAtMillis = expiresAtMillis;
            this.expiresAtMillisBuildStage = 1;
        }

        boolean keepRefreshed() {
            if (this.keepRefreshedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keepRefreshedBuildStage == 0) {
                boolean computedValue;
                this.keepRefreshedBuildStage = (byte)-1;
                this.keepRefreshed = computedValue = ImmutableAuthConfig.this.keepRefreshedInitialize();
                this.keepRefreshedBuildStage = 1;
            }
            return this.keepRefreshed;
        }

        void keepRefreshed(boolean keepRefreshed) {
            this.keepRefreshed = keepRefreshed;
            this.keepRefreshedBuildStage = 1;
        }

        boolean exchangeEnabled() {
            if (this.exchangeEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exchangeEnabledBuildStage == 0) {
                boolean computedValue;
                this.exchangeEnabledBuildStage = (byte)-1;
                this.exchangeEnabled = computedValue = ImmutableAuthConfig.this.exchangeEnabledInitialize();
                this.exchangeEnabledBuildStage = 1;
            }
            return this.exchangeEnabled;
        }

        void exchangeEnabled(boolean exchangeEnabled) {
            this.exchangeEnabled = exchangeEnabled;
            this.exchangeEnabledBuildStage = 1;
        }

        String oauth2ServerUri() {
            if (this.oauth2ServerUriBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.oauth2ServerUriBuildStage == 0) {
                String computedValue;
                this.oauth2ServerUriBuildStage = (byte)-1;
                this.oauth2ServerUri = computedValue = ImmutableAuthConfig.this.oauth2ServerUriInitialize();
                this.oauth2ServerUriBuildStage = 1;
            }
            return this.oauth2ServerUri;
        }

        void oauth2ServerUri(String oauth2ServerUri) {
            this.oauth2ServerUri = oauth2ServerUri;
            this.oauth2ServerUriBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.scopeBuildStage == -1) {
                attributes.add("scope");
            }
            if (this.expiresAtMillisBuildStage == -1) {
                attributes.add("expiresAtMillis");
            }
            if (this.keepRefreshedBuildStage == -1) {
                attributes.add("keepRefreshed");
            }
            if (this.exchangeEnabledBuildStage == -1) {
                attributes.add("exchangeEnabled");
            }
            if (this.oauth2ServerUriBuildStage == -1) {
                attributes.add("oauth2ServerUri");
            }
            return "Cannot build AuthConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="AuthConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_EXPIRES_AT_MILLIS = 1L;
        private static final long OPT_BIT_KEEP_REFRESHED = 2L;
        private static final long OPT_BIT_EXCHANGE_ENABLED = 4L;
        private static final long OPT_BIT_OAUTH2_SERVER_URI = 8L;
        private long optBits;
        @Nullable
        private String token;
        @Nullable
        private String tokenType;
        @Nullable
        private String credential;
        @Nullable
        private String scope;
        @Nullable
        private Long expiresAtMillis;
        private boolean keepRefreshed;
        private boolean exchangeEnabled;
        @Nullable
        private String oauth2ServerUri;
        private Map<String, String> optionalOAuthParams = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AuthConfig instance) {
            String credentialValue;
            String tokenTypeValue;
            Objects.requireNonNull(instance, "instance");
            String tokenValue = instance.token();
            if (tokenValue != null) {
                this.token(tokenValue);
            }
            if ((tokenTypeValue = instance.tokenType()) != null) {
                this.tokenType(tokenTypeValue);
            }
            if ((credentialValue = instance.credential()) != null) {
                this.credential(credentialValue);
            }
            this.scope(instance.scope());
            Long expiresAtMillisValue = instance.expiresAtMillis();
            if (expiresAtMillisValue != null) {
                this.expiresAtMillis(expiresAtMillisValue);
            }
            this.keepRefreshed(instance.keepRefreshed());
            this.exchangeEnabled(instance.exchangeEnabled());
            String oauth2ServerUriValue = instance.oauth2ServerUri();
            if (oauth2ServerUriValue != null) {
                this.oauth2ServerUri(oauth2ServerUriValue);
            }
            this.putAllOptionalOAuthParams(instance.optionalOAuthParams());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(@Nullable String token) {
            this.token = token;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenType(@Nullable String tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credential(@Nullable String credential) {
            this.credential = credential;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expiresAtMillis(@Nullable Long expiresAtMillis) {
            this.expiresAtMillis = expiresAtMillis;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keepRefreshed(boolean keepRefreshed) {
            this.keepRefreshed = keepRefreshed;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder exchangeEnabled(boolean exchangeEnabled) {
            this.exchangeEnabled = exchangeEnabled;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oauth2ServerUri(@Nullable String oauth2ServerUri) {
            this.oauth2ServerUri = oauth2ServerUri;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptionalOAuthParams(String key, String value) {
            this.optionalOAuthParams.put(Objects.requireNonNull(key, "optionalOAuthParams key"), Objects.requireNonNull(value, value == null ? "optionalOAuthParams value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptionalOAuthParams(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.optionalOAuthParams.put(Objects.requireNonNull(k, "optionalOAuthParams key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "optionalOAuthParams value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder optionalOAuthParams(Map<String, ? extends String> entries) {
            this.optionalOAuthParams.clear();
            return this.putAllOptionalOAuthParams(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptionalOAuthParams(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.optionalOAuthParams.put(Objects.requireNonNull(k, "optionalOAuthParams key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "optionalOAuthParams value for key: " + k : null));
            }
            return this;
        }

        public ImmutableAuthConfig build() {
            return new ImmutableAuthConfig(this);
        }

        private boolean expiresAtMillisIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean keepRefreshedIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean exchangeEnabledIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean oauth2ServerUriIsSet() {
            return (this.optBits & 8L) != 0L;
        }
    }
}

