/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.Locale;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public enum PlanStatus {
    COMPLETED("completed"),
    SUBMITTED("submitted"),
    CANCELLED("cancelled"),
    FAILED("failed");

    private final String status;

    private PlanStatus(String status) {
        this.status = status;
    }

    public String status() {
        return this.status;
    }

    public static PlanStatus fromName(String status) {
        Preconditions.checkArgument(status != null, "Status is null");
        try {
            return PlanStatus.valueOf(status.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid status name: %s", status), e);
        }
    }
}

