/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.iceberg.parquet.ParquetVariantUtil;
import org.apache.iceberg.parquet.ParquetVariantVisitor;
import org.apache.iceberg.parquet.ParquetVariantWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.schema.GroupType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.VariantValue;

public class VariantWriterBuilder
extends ParquetVariantVisitor<ParquetValueWriter<?>> {
    private final MessageType schema;
    private final Iterable<String> basePath;
    private final Deque<String> fieldNames = Lists.newLinkedList();

    public VariantWriterBuilder(MessageType schema, Iterable<String> basePath) {
        this.schema = schema;
        this.basePath = basePath;
    }

    @Override
    public void beforeField(Type type) {
        this.fieldNames.addLast(type.getName());
    }

    @Override
    public void afterField(Type type) {
        this.fieldNames.removeLast();
    }

    private String[] currentPath() {
        return (String[])Streams.concat(Streams.stream(this.basePath), this.fieldNames.stream()).toArray(String[]::new);
    }

    private String[] path(String ... names) {
        return (String[])Streams.concat(Streams.stream(this.basePath), this.fieldNames.stream(), Stream.of(names)).toArray(String[]::new);
    }

    @Override
    public ParquetValueWriter<?> variant(GroupType variant, ParquetValueWriter<?> metadataWriter, ParquetValueWriter<?> valueWriter) {
        return ParquetVariantWriters.variant(metadataWriter, valueWriter);
    }

    @Override
    public ParquetValueWriter<?> metadata(PrimitiveType metadata) {
        ColumnDescriptor desc = this.schema.getColumnDescription(this.currentPath());
        return ParquetVariantWriters.metadata(ParquetValueWriters.byteBuffers(desc));
    }

    @Override
    public ParquetValueWriter<?> serialized(PrimitiveType value) {
        ColumnDescriptor desc = this.schema.getColumnDescription(this.currentPath());
        return ParquetVariantWriters.value(ParquetValueWriters.byteBuffers(desc));
    }

    @Override
    public ParquetValueWriter<?> primitive(PrimitiveType primitive) {
        ColumnDescriptor desc = this.schema.getColumnDescription(this.currentPath());
        LogicalTypeAnnotation annotation = primitive.getLogicalTypeAnnotation();
        if (annotation != null) {
            Optional writer = annotation.accept(new LogicalTypeToVariantWriter(desc));
            if (writer.isPresent()) {
                return (ParquetValueWriter)writer.get();
            }
        } else {
            switch (primitive.getPrimitiveTypeName()) {
                case BINARY: {
                    return ParquetVariantWriters.primitive(ParquetValueWriters.byteBuffers(desc), PhysicalType.BINARY);
                }
                case BOOLEAN: {
                    return ParquetVariantWriters.primitive(ParquetValueWriters.booleans(desc), PhysicalType.BOOLEAN_TRUE, PhysicalType.BOOLEAN_FALSE);
                }
                case INT32: {
                    return ParquetVariantWriters.primitive(ParquetValueWriters.ints(desc), PhysicalType.INT32);
                }
                case INT64: {
                    return ParquetVariantWriters.primitive(ParquetValueWriters.longs(desc), PhysicalType.INT64);
                }
                case FLOAT: {
                    return ParquetVariantWriters.primitive(ParquetValueWriters.unboxed(desc), PhysicalType.FLOAT);
                }
                case DOUBLE: {
                    return ParquetVariantWriters.primitive(ParquetValueWriters.unboxed(desc), PhysicalType.DOUBLE);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported shredded value type: " + String.valueOf(primitive));
    }

    @Override
    public ParquetValueWriter<?> value(GroupType value, ParquetValueWriter<?> valueWriter, ParquetValueWriter<?> typedWriter) {
        int valueDL = this.schema.getMaxDefinitionLevel(this.path("value"));
        if (typedWriter != null) {
            int typedValueDL = this.schema.getMaxDefinitionLevel(this.path("typed_value"));
            return ParquetVariantWriters.shredded(valueDL, valueWriter, typedValueDL, typedWriter);
        }
        if (value.getType("value").isRepetition(Type.Repetition.OPTIONAL)) {
            return ParquetValueWriters.option(value.getType("value"), valueDL, valueWriter);
        }
        return valueWriter;
    }

    @Override
    public ParquetValueWriter<?> object(GroupType object, ParquetValueWriter<?> valueWriter, List<ParquetValueWriter<?>> fieldWriters) {
        int valueDL = this.schema.getMaxDefinitionLevel(this.path("value"));
        int typedDL = this.schema.getMaxDefinitionLevel(this.path("typed_value"));
        GroupType firstField = object.getType("typed_value").asGroupType().getType(0).asGroupType();
        int fieldDL = this.schema.getMaxDefinitionLevel(this.path("typed_value", firstField.getName(), firstField.getType(0).getName()));
        List<String> names = object.getType("typed_value").asGroupType().getFields().stream().map(Type::getName).collect(Collectors.toList());
        return ParquetVariantWriters.objects(valueDL, valueWriter, typedDL, fieldDL, names, fieldWriters);
    }

    @Override
    public ParquetValueWriter<?> array(GroupType array, ParquetValueWriter<?> valueWriter, ParquetValueWriter<?> elementWriter) {
        int valueDL = this.schema.getMaxDefinitionLevel(this.path("value"));
        int typedDL = this.schema.getMaxDefinitionLevel(this.path("typed_value"));
        int repeatedDL = this.schema.getMaxDefinitionLevel(this.path("typed_value", "list"));
        int repeatedRL = this.schema.getMaxRepetitionLevel(this.path("typed_value", "list"));
        ParquetValueWriter<VariantValue> typedWriter = ParquetVariantWriters.array(repeatedDL, repeatedRL, elementWriter);
        return ParquetVariantWriters.shredded(valueDL, valueWriter, typedDL, typedWriter);
    }

    private static class LogicalTypeToVariantWriter
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<ParquetValueWriter<?>> {
        private final ColumnDescriptor desc;

        private LogicalTypeToVariantWriter(ColumnDescriptor desc) {
            this.desc = desc;
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation ignored) {
            ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.strings(this.desc), PhysicalType.STRING);
            return Optional.of(writer);
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimal) {
            switch (this.desc.getPrimitiveType().getPrimitiveTypeName()) {
                case BINARY: 
                case FIXED_LEN_BYTE_ARRAY: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.decimalAsFixed(this.desc, decimal.getPrecision(), decimal.getScale()), PhysicalType.DECIMAL16);
                    return Optional.of(writer);
                }
                case INT64: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.decimalAsLong(this.desc, decimal.getPrecision(), decimal.getScale()), PhysicalType.DECIMAL8);
                    return Optional.of(writer);
                }
                case INT32: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.decimalAsInteger(this.desc, decimal.getPrecision(), decimal.getScale()), PhysicalType.DECIMAL4);
                    return Optional.of(writer);
                }
            }
            throw new IllegalArgumentException("Invalid primitive type for decimal: " + String.valueOf(this.desc.getPrimitiveType()));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation ignored) {
            ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.ints(this.desc), PhysicalType.DATE);
            return Optional.of(writer);
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation time) {
            ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.longs(this.desc), PhysicalType.TIME);
            return Optional.of(writer);
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestamp) {
            return Optional.of(ParquetVariantWriters.primitive(ParquetValueWriters.longs(this.desc), ParquetVariantUtil.convert(timestamp)));
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation logical) {
            Preconditions.checkArgument(logical.isSigned(), "Invalid logical type for variant, unsigned: %s", (Object)logical);
            switch (logical.getBitWidth()) {
                case 8: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.tinyints(this.desc), PhysicalType.INT8);
                    return Optional.of(writer);
                }
                case 16: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.shorts(this.desc), PhysicalType.INT16);
                    return Optional.of(writer);
                }
                case 32: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.ints(this.desc), PhysicalType.INT32);
                    return Optional.of(writer);
                }
                case 64: {
                    ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.longs(this.desc), PhysicalType.INT64);
                    return Optional.of(writer);
                }
            }
            throw new IllegalArgumentException("Invalid bit width for int: " + logical.getBitWidth());
        }

        @Override
        public Optional<ParquetValueWriter<?>> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            ParquetValueWriter<VariantValue> writer = ParquetVariantWriters.primitive(ParquetValueWriters.uuids(this.desc), PhysicalType.UUID);
            return Optional.of(writer);
        }
    }
}

