/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.iceberg.shaded.org.apache.parquet.io.api.RecordConsumer;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;

class ParquetWriteSupport<T>
extends WriteSupport<T> {
    private final MessageType type;
    private final Map<String, String> keyValueMetadata;
    private final WriteSupport<T> wrapped;

    ParquetWriteSupport(MessageType type, Map<String, String> keyValueMetadata, WriteSupport<T> writeSupport) {
        this.type = type;
        this.keyValueMetadata = keyValueMetadata;
        this.wrapped = writeSupport;
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        WriteSupport.WriteContext wrappedContext = this.wrapped.init(configuration);
        ImmutableMap<String, String> metadata = ImmutableMap.builder().putAll(this.keyValueMetadata).putAll(wrappedContext.getExtraMetaData()).buildOrThrow();
        return new WriteSupport.WriteContext(this.type, metadata);
    }

    @Override
    public String getName() {
        return "Iceberg/" + this.wrapped.getName();
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.wrapped.prepareForWrite(recordConsumer);
    }

    @Override
    public void write(T t2) {
        this.wrapped.write(t2);
    }

    @Override
    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        return this.wrapped.finalizeWrite();
    }
}

