/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.stream.Streams;
import org.apache.iceberg.parquet.ColumnIterator;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueReaders;
import org.apache.iceberg.parquet.TripleIterator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.shaded.org.apache.parquet.column.ColumnDescriptor;
import org.apache.iceberg.shaded.org.apache.parquet.column.page.PageReadStore;
import org.apache.iceberg.variants.PhysicalType;
import org.apache.iceberg.variants.ShreddedObject;
import org.apache.iceberg.variants.ValueArray;
import org.apache.iceberg.variants.Variant;
import org.apache.iceberg.variants.VariantMetadata;
import org.apache.iceberg.variants.VariantObject;
import org.apache.iceberg.variants.VariantPrimitive;
import org.apache.iceberg.variants.VariantValue;
import org.apache.iceberg.variants.Variants;

public class ParquetVariantReaders {
    private static final VariantValue MISSING = null;

    private ParquetVariantReaders() {
    }

    public static ParquetValueReader<Variant> variant(ParquetValueReader<?> metadata, ParquetValueReader<?> value) {
        return new VariantReader(metadata, (VariantValueReader)value);
    }

    public static ParquetValueReader<VariantMetadata> metadata(ColumnDescriptor desc) {
        return new VariantMetadataReader(desc);
    }

    public static VariantValueReader serialized(ColumnDescriptor desc) {
        return new SerializedVariantReader(desc);
    }

    public static VariantValueReader shredded(int valueDefinitionLevel, ParquetValueReader<?> valueReader, int typedDefinitionLevel, ParquetValueReader<?> typedReader) {
        return new ShreddedVariantReader(valueDefinitionLevel, (VariantValueReader)valueReader, typedDefinitionLevel, (VariantValueReader)typedReader);
    }

    public static VariantValueReader objects(int valueDefinitionLevel, ParquetValueReader<?> valueReader, int typedDefinitionLevel, List<String> fieldNames, List<VariantValueReader> fieldReaders) {
        return new ShreddedObjectReader(valueDefinitionLevel, (VariantValueReader)valueReader, typedDefinitionLevel, fieldNames, fieldReaders);
    }

    public static VariantValueReader array(int repeatedDefinitionLevel, int repeatedRepetitionLevel, ParquetValueReader<?> elementReader) {
        return new ArrayReader(repeatedDefinitionLevel, repeatedRepetitionLevel, (VariantValueReader)elementReader);
    }

    public static VariantValueReader asVariant(PhysicalType type, ParquetValueReader<?> reader) {
        return new ValueAsVariantReader(type, reader);
    }

    private static ByteBuffer readBinary(ColumnIterator<?> column) {
        ByteBuffer data = column.nextBinary().toByteBuffer();
        byte[] array = new byte[data.remaining()];
        data.get(array, 0, data.remaining());
        return ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static VariantValue read(VariantMetadata metadata, VariantValueReader reader, int definitionLevel) {
        if (reader != null) {
            if (reader.column().currentDefinitionLevel() > definitionLevel) {
                return reader.read(metadata);
            }
            for (TripleIterator<?> child : reader.columns()) {
                child.nextNull();
            }
        }
        return MISSING;
    }

    private static List<TripleIterator<?>> children(ParquetValueReader<?> ... readers) {
        return ParquetVariantReaders.children(Arrays.asList(readers));
    }

    private static List<TripleIterator<?>> children(Iterable<ParquetValueReader<?>> readers) {
        return ImmutableList.copyOf(Iterables.concat(Iterables.transform(Streams.of(readers).filter(Objects::nonNull).collect(Collectors.toList()), ParquetValueReader::columns)));
    }

    private static class VariantReader
    implements ParquetValueReader<Variant> {
        private final ParquetValueReader<VariantMetadata> metadataReader;
        private final VariantValueReader valueReader;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        private VariantReader(ParquetValueReader<VariantMetadata> metadataReader, VariantValueReader valueReader) {
            this.metadataReader = metadataReader;
            this.valueReader = valueReader;
            this.column = metadataReader.column();
            this.children = ParquetVariantReaders.children(metadataReader, valueReader);
        }

        @Override
        public Variant read(Variant ignored) {
            VariantMetadata metadata;
            VariantPrimitive<Void> value = this.valueReader.read(metadata = (VariantMetadata)this.metadataReader.read(null));
            return Variant.of(metadata, value != MISSING ? value : Variants.ofNull());
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        @Override
        public void setPageSource(PageReadStore pageStore) {
            this.metadataReader.setPageSource(pageStore);
            this.valueReader.setPageSource(pageStore);
        }
    }

    public static interface VariantValueReader
    extends ParquetValueReader<VariantValue> {
        @Override
        default public VariantValue read(VariantValue reuse) {
            throw new UnsupportedOperationException("Variants must be read using read(VariantMetadata)");
        }

        @Override
        public VariantValue read(VariantMetadata var1);
    }

    private static class VariantMetadataReader
    extends ParquetValueReaders.PrimitiveReader<VariantMetadata> {
        private VariantMetadataReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public VariantMetadata read(VariantMetadata reuse) {
            return Variants.metadata(ParquetVariantReaders.readBinary(this.column));
        }
    }

    private static class SerializedVariantReader
    extends ParquetValueReaders.PrimitiveReader<VariantValue>
    implements VariantValueReader {
        private SerializedVariantReader(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public VariantValue read(VariantMetadata metadata) {
            return Variants.value(metadata, ParquetVariantReaders.readBinary(this.column));
        }
    }

    private static class ShreddedVariantReader
    implements VariantValueReader {
        private final int valueDefinitionLevel;
        private final VariantValueReader valueReader;
        private final int typeDefinitionLevel;
        private final VariantValueReader typedReader;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        private ShreddedVariantReader(int valueDefinitionLevel, VariantValueReader valueReader, int typeDefinitionLevel, VariantValueReader typedReader) {
            this.valueDefinitionLevel = valueDefinitionLevel;
            this.valueReader = valueReader;
            this.typeDefinitionLevel = typeDefinitionLevel;
            this.typedReader = typedReader;
            this.column = valueReader != null ? valueReader.column() : typedReader.column();
            this.children = ParquetVariantReaders.children(valueReader, typedReader);
        }

        @Override
        public VariantValue read(VariantMetadata metadata) {
            VariantValue value = ParquetVariantReaders.read(metadata, this.valueReader, this.valueDefinitionLevel);
            VariantValue typed = ParquetVariantReaders.read(metadata, this.typedReader, this.typeDefinitionLevel);
            if (typed != null) {
                Preconditions.checkArgument(value == null, "Invalid variant, conflicting value and typed_value: value=%s typed_value=%s", (Object)value, (Object)typed);
                return typed;
            }
            return value;
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        @Override
        public void setPageSource(PageReadStore pageStore) {
            if (this.valueReader != null) {
                this.valueReader.setPageSource(pageStore);
            }
            if (this.typedReader != null) {
                this.typedReader.setPageSource(pageStore);
            }
        }
    }

    private static class ShreddedObjectReader
    implements VariantValueReader {
        private final int valueDefinitionLevel;
        private final VariantValueReader valueReader;
        private final int fieldsDefinitionLevel;
        private final String[] fieldNames;
        private final VariantValueReader[] fieldReaders;
        private final TripleIterator<?> valueColumn;
        private final TripleIterator<?> fieldColumn;
        private final List<TripleIterator<?>> children;

        private ShreddedObjectReader(int valueDefinitionLevel, VariantValueReader valueReader, int fieldsDefinitionLevel, List<String> fieldNames, List<VariantValueReader> fieldReaders) {
            this.valueDefinitionLevel = valueDefinitionLevel;
            this.valueReader = valueReader;
            this.fieldsDefinitionLevel = fieldsDefinitionLevel;
            this.fieldNames = (String[])fieldNames.toArray(String[]::new);
            this.fieldReaders = (VariantValueReader[])fieldReaders.toArray(VariantValueReader[]::new);
            this.fieldColumn = this.fieldReaders[0].column();
            this.valueColumn = valueReader != null ? valueReader.column() : this.fieldColumn;
            this.children = ParquetVariantReaders.children(Iterables.concat(Arrays.asList(valueReader), fieldReaders));
        }

        @Override
        public VariantValue read(VariantMetadata metadata) {
            boolean isObject = this.fieldColumn.currentDefinitionLevel() > this.fieldsDefinitionLevel;
            VariantValue value = ParquetVariantReaders.read(metadata, this.valueReader, this.valueDefinitionLevel);
            if (isObject) {
                ShreddedObject object;
                if (value == MISSING) {
                    object = Variants.object(metadata);
                } else {
                    Preconditions.checkArgument(value.type() == PhysicalType.OBJECT, "Invalid variant, non-object value with shredded fields: %s", (Object)value);
                    object = Variants.object(metadata, (VariantObject)value);
                }
                for (int i = 0; i < this.fieldReaders.length; ++i) {
                    String name = this.fieldNames[i];
                    VariantValue fieldValue = this.fieldReaders[i].read(metadata);
                    if (fieldValue == MISSING) {
                        object.remove(name);
                        continue;
                    }
                    object.put(name, fieldValue);
                }
                return object;
            }
            for (VariantValueReader reader : this.fieldReaders) {
                for (TripleIterator<?> child : reader.columns()) {
                    child.nextNull();
                }
            }
            return value;
        }

        @Override
        public TripleIterator<?> column() {
            return this.valueColumn;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }

        @Override
        public void setPageSource(PageReadStore pageStore) {
            if (this.valueReader != null) {
                this.valueReader.setPageSource(pageStore);
            }
            for (VariantValueReader reader : this.fieldReaders) {
                reader.setPageSource(pageStore);
            }
        }
    }

    private static class ArrayReader
    implements VariantValueReader {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final VariantValueReader reader;
        private final TripleIterator<?> column;
        private final List<TripleIterator<?>> children;

        protected ArrayReader(int definitionLevel, int repetitionLevel, VariantValueReader reader) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.reader = reader;
            this.column = reader.column();
            this.children = reader.columns();
        }

        @Override
        public void setPageSource(PageReadStore pageStore) {
            this.reader.setPageSource(pageStore);
        }

        @Override
        public ValueArray read(VariantMetadata metadata) {
            ValueArray arr = Variants.array();
            do {
                if (this.column.currentDefinitionLevel() > this.definitionLevel) {
                    VariantPrimitive<Void> value = this.reader.read(metadata);
                    arr.add(value != null ? value : Variants.ofNull());
                    continue;
                }
                for (TripleIterator<?> child : this.children) {
                    child.nextNull();
                }
                break;
            } while (this.column.currentRepetitionLevel() > this.repetitionLevel);
            return arr;
        }

        @Override
        public TripleIterator<?> column() {
            return this.column;
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.children;
        }
    }

    private static class ValueAsVariantReader<V>
    extends DelegatingValueReader<V, VariantValue>
    implements VariantValueReader {
        private final PhysicalType type;

        private ValueAsVariantReader(PhysicalType type, ParquetValueReader<V> reader) {
            super(reader);
            this.type = type;
        }

        @Override
        public VariantValue read(VariantMetadata ignored) {
            return Variants.of(this.type, this.readFromDelegate(null));
        }
    }

    public static abstract class DelegatingValueReader<S, T>
    implements ParquetValueReader<T> {
        private final ParquetValueReader<S> reader;

        protected DelegatingValueReader(ParquetValueReader<S> reader) {
            this.reader = reader;
        }

        protected S readFromDelegate(S reuse) {
            return this.reader.read(reuse);
        }

        @Override
        public TripleIterator<?> column() {
            return this.reader.column();
        }

        @Override
        public List<TripleIterator<?>> columns() {
            return this.reader.columns();
        }

        @Override
        public void setPageSource(PageReadStore pageStore) {
            this.reader.setPageSource(pageStore);
        }
    }
}

