/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.Collections;
import java.util.Set;
import org.apache.iceberg.metrics.MetricsReport;
import org.apache.iceberg.metrics.MetricsReporter;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReporters {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsReporters.class);

    private MetricsReporters() {
    }

    public static MetricsReporter combine(MetricsReporter first, MetricsReporter second) {
        if (null == first) {
            return second;
        }
        if (null == second || first == second) {
            return first;
        }
        Set<MetricsReporter> reporters = Sets.newIdentityHashSet();
        if (first instanceof CompositeMetricsReporter) {
            reporters.addAll(((CompositeMetricsReporter)first).reporters());
        } else {
            reporters.add(first);
        }
        if (second instanceof CompositeMetricsReporter) {
            reporters.addAll(((CompositeMetricsReporter)second).reporters());
        } else {
            reporters.add(second);
        }
        return new CompositeMetricsReporter(reporters);
    }

    @VisibleForTesting
    static class CompositeMetricsReporter
    implements MetricsReporter {
        private final Set<MetricsReporter> reporters;

        private CompositeMetricsReporter(Set<MetricsReporter> reporters) {
            this.reporters = reporters;
        }

        @Override
        public void report(MetricsReport report) {
            for (MetricsReporter reporter : this.reporters) {
                try {
                    reporter.report(report);
                }
                catch (Exception e) {
                    LOG.warn("Could not report {} to {}", new Object[]{report.getClass().getName(), reporter.getClass().getName(), e});
                }
            }
        }

        @Override
        public void close() {
            for (MetricsReporter reporter : this.reporters) {
                try {
                    reporter.close();
                }
                catch (Exception e) {
                    LOG.warn("Failed to close metrics reporter {}", (Object)reporter.getClass().getName(), (Object)e);
                }
            }
        }

        Set<MetricsReporter> reporters() {
            return Collections.unmodifiableSet(this.reporters);
        }
    }
}

