/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.metrics.CommitMetrics;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitMetrics", generator="Immutables")
@Immutable
public final class ImmutableCommitMetrics
extends CommitMetrics {
    private final MetricsContext metricsContext;
    private final transient Timer totalDuration;
    private final transient Counter attempts;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCommitMetrics(MetricsContext metricsContext) {
        this.metricsContext = metricsContext;
        this.totalDuration = this.initShim.totalDuration();
        this.attempts = this.initShim.attempts();
        this.initShim = null;
    }

    @Override
    public MetricsContext metricsContext() {
        return this.metricsContext;
    }

    @Override
    public Timer totalDuration() {
        InitShim shim = this.initShim;
        return shim != null ? shim.totalDuration() : this.totalDuration;
    }

    @Override
    public Counter attempts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.attempts() : this.attempts;
    }

    public final ImmutableCommitMetrics withMetricsContext(MetricsContext value) {
        if (this.metricsContext == value) {
            return this;
        }
        MetricsContext newValue = Objects.requireNonNull(value, "metricsContext");
        return new ImmutableCommitMetrics(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitMetrics && this.equalsByValue((ImmutableCommitMetrics)another);
    }

    private boolean equalsByValue(ImmutableCommitMetrics another) {
        return this.metricsContext.equals(another.metricsContext) && this.totalDuration.equals(another.totalDuration) && this.attempts.equals(another.attempts);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.metricsContext.hashCode();
        h2 += (h2 << 5) + this.totalDuration.hashCode();
        h2 += (h2 << 5) + this.attempts.hashCode();
        return h2;
    }

    public String toString() {
        return "CommitMetrics{metricsContext=" + String.valueOf(this.metricsContext) + ", totalDuration=" + String.valueOf(this.totalDuration) + ", attempts=" + String.valueOf(this.attempts) + "}";
    }

    public static ImmutableCommitMetrics copyOf(CommitMetrics instance) {
        if (instance instanceof ImmutableCommitMetrics) {
            return (ImmutableCommitMetrics)instance;
        }
        return ImmutableCommitMetrics.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitMetrics", generator="Immutables")
    private final class InitShim {
        private byte totalDurationBuildStage = 0;
        private Timer totalDuration;
        private byte attemptsBuildStage = 0;
        private Counter attempts;

        private InitShim() {
        }

        Timer totalDuration() {
            if (this.totalDurationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.totalDurationBuildStage == 0) {
                this.totalDurationBuildStage = (byte)-1;
                Timer computedValue = ImmutableCommitMetrics.super.totalDuration();
                this.totalDuration = Objects.requireNonNull(computedValue, "totalDuration");
                this.totalDurationBuildStage = 1;
            }
            return this.totalDuration;
        }

        Counter attempts() {
            if (this.attemptsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.attemptsBuildStage == 0) {
                this.attemptsBuildStage = (byte)-1;
                Counter computedValue = ImmutableCommitMetrics.super.attempts();
                this.attempts = Objects.requireNonNull(computedValue, "attempts");
                this.attemptsBuildStage = 1;
            }
            return this.attempts;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.totalDurationBuildStage == -1) {
                attributes.add("totalDuration");
            }
            if (this.attemptsBuildStage == -1) {
                attributes.add("attempts");
            }
            return "Cannot build CommitMetrics, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="CommitMetrics", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METRICS_CONTEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private MetricsContext metricsContext;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitMetrics instance) {
            Objects.requireNonNull(instance, "instance");
            this.metricsContext(instance.metricsContext());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metricsContext(MetricsContext metricsContext) {
            this.metricsContext = Objects.requireNonNull(metricsContext, "metricsContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCommitMetrics build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitMetrics(this.metricsContext);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metricsContext");
            }
            return "Cannot build CommitMetrics, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

