/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.iceberg.BaseMetastoreOperations;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.CommitStateUnknownException;
import org.apache.iceberg.exceptions.NoSuchViewException;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hive.HMSTablePropertyHelper;
import org.apache.iceberg.hive.HiveHadoopUtil;
import org.apache.iceberg.hive.HiveLock;
import org.apache.iceberg.hive.HiveOperationsBase;
import org.apache.iceberg.hive.LockException;
import org.apache.iceberg.hive.MetastoreLock;
import org.apache.iceberg.hive.NoLock;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.view.BaseViewOperations;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.ViewMetadata;
import org.apache.iceberg.view.ViewRepresentation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HiveViewOperations
extends BaseViewOperations
implements HiveOperationsBase {
    private static final Logger LOG = LoggerFactory.getLogger(HiveViewOperations.class);
    private final String fullName;
    private final String database;
    private final String viewName;
    private final FileIO fileIO;
    private final ClientPool<IMetaStoreClient, TException> metaClients;
    private final long maxHiveTablePropertySize;
    private final Configuration conf;
    private final String catalogName;

    HiveViewOperations(Configuration conf, ClientPool<IMetaStoreClient, TException> metaClients, FileIO fileIO, String catalogName, TableIdentifier viewIdentifier) {
        this.conf = conf;
        this.catalogName = catalogName;
        this.metaClients = metaClients;
        this.fileIO = fileIO;
        this.fullName = CatalogUtil.fullTableName(catalogName, viewIdentifier);
        this.database = viewIdentifier.namespace().level(0);
        this.viewName = viewIdentifier.name();
        this.maxHiveTablePropertySize = conf.getLong("iceberg.hive.table-property-max-size", 32672L);
    }

    @Override
    public void doRefresh() {
        String metadataLocation = null;
        try {
            Table table = this.metaClients.run(client -> client.getTable(this.database, this.viewName));
            HiveOperationsBase.validateIcebergTableNotLoadedAsIcebergView(table, this.fullName);
            HiveOperationsBase.validateTableIsIcebergView(table, this.fullName);
            metadataLocation = (String)table.getParameters().get("metadata_location");
        }
        catch (NoSuchObjectException e) {
            if (this.currentMetadataLocation() != null) {
                throw new NoSuchViewException("View does not exist: %s.%s", this.database, this.viewName);
            }
        }
        catch (TException e) {
            String errMsg = String.format("Failed to get view info from metastore %s.%s", this.database, this.viewName);
            throw new RuntimeException(errMsg, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during refresh", e);
        }
        this.refreshFromMetadataLocation(metadataLocation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void doCommit(ViewMetadata base, ViewMetadata metadata) {
        newView = base == null;
        newMetadataLocation = this.writeNewMetadataIfRequired(metadata);
        hiveEngineEnabled = false;
        commitStatus = BaseMetastoreOperations.CommitStatus.FAILURE;
        updateHiveView = false;
        lock = this.lockObject();
        try {
            lock.lock();
            tbl = this.loadHmsTable();
            if (tbl != null) {
                if (newView && tbl.getParameters().get("metadata_location") != null) {
                    throw new org.apache.iceberg.exceptions.AlreadyExistsException("%s already exists: %s.%s", new Object[]{TableType.VIRTUAL_VIEW.name().equalsIgnoreCase(tbl.getTableType()) != false ? HiveOperationsBase.ContentType.VIEW.value() : HiveOperationsBase.ContentType.TABLE.value(), this.database, this.viewName});
                }
                updateHiveView = true;
                HiveViewOperations.LOG.debug("Committing existing view: {}", (Object)this.fullName);
            } else {
                tbl = this.newHMSView(metadata);
                HiveViewOperations.LOG.debug("Committing new view: {}", (Object)this.fullName);
            }
            tbl.setSd(HiveOperationsBase.storageDescriptor(metadata.schema(), metadata.location(), hiveEngineEnabled));
            metadataLocation = (String)tbl.getParameters().get("metadata_location");
            v0 = baseMetadataLocation = base != null ? base.metadataFileLocation() : null;
            if (!Objects.equals(baseMetadataLocation, metadataLocation)) {
                throw new CommitFailedException("Cannot commit: Base metadata location '%s' is not same as the current view metadata location '%s' for %s.%s", new Object[]{baseMetadataLocation, metadataLocation, this.database, this.viewName});
            }
            removedProps /* !! */  = Collections.emptySet();
            if (base != null) {
                removedProps /* !! */  = base.properties().keySet().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doCommit$1(org.apache.iceberg.view.ViewMetadata java.lang.String ), (Ljava/lang/String;)Z)((ViewMetadata)metadata)).collect(Collectors.toSet());
            }
            HMSTablePropertyHelper.updateHmsTableForIcebergView(newMetadataLocation, tbl, metadata, removedProps /* !! */ , this.maxHiveTablePropertySize, this.currentMetadataLocation());
            lock.ensureActive();
            try {
                this.persistTable(tbl, updateHiveView, HiveViewOperations.hiveLockEnabled(this.conf) != false ? null : baseMetadataLocation);
                lock.ensureActive();
                commitStatus = BaseMetastoreOperations.CommitStatus.SUCCESS;
            }
            catch (LockException le) {
                commitStatus = BaseMetastoreOperations.CommitStatus.UNKNOWN;
                throw new CommitStateUnknownException("Failed to heartbeat for hive lock while committing changes. This can lead to a concurrent commit attempt be able to overwrite this commit. Please check the commit history. If you are running into this issue, try reducing iceberg.hive.lock-heartbeat-interval-ms.", le);
            }
            catch (AlreadyExistsException e) {
                throw new org.apache.iceberg.exceptions.AlreadyExistsException(e, "View already exists: %s.%s", new Object[]{this.database, this.viewName});
            }
            catch (InvalidObjectException e) {
                throw new ValidationException(e, "Invalid Hive object for %s.%s", new Object[]{this.database, this.viewName});
            }
            catch (CommitFailedException | CommitStateUnknownException e) {
                throw e;
            }
            catch (Throwable e) {
                if (e.getMessage() != null && e.getMessage().contains("The table has been modified. The parameter value for key 'metadata_location' is")) {
                    throw new CommitFailedException(e, "The view %s.%s has been modified concurrently", new Object[]{this.database, this.viewName});
                }
                if (e.getMessage() != null && e.getMessage().contains("Table/View 'HIVE_LOCKS' does not exist")) {
                    throw new RuntimeException("Failed to acquire locks from metastore because the underlying metastore view 'HIVE_LOCKS' does not exist. This can occur when using an embedded metastore which does not support transactions. To fix this use an alternative metastore.", e);
                }
                HiveViewOperations.LOG.error("Cannot tell if commit to {}.{} succeeded, attempting to reconnect and check.", new Object[]{this.database, this.viewName, e});
                commitStatus = BaseMetastoreOperations.CommitStatus.UNKNOWN;
                commitStatus = this.checkCommitStatus(this.viewName, newMetadataLocation, metadata.properties(), (Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doCommit$2(java.lang.String ), ()Ljava/lang/Boolean;)((HiveViewOperations)this, (String)newMetadataLocation));
                switch (1.$SwitchMap$org$apache$iceberg$BaseMetastoreOperations$CommitStatus[commitStatus.ordinal()]) {
                    case 1: {
                        ** break;
lbl53:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        throw e;
                    }
                    case 3: {
                        throw new CommitStateUnknownException(e);
                    }
                    ** default:
lbl59:
                    // 1 sources

                    break;
                }
            }
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s.%s", new Object[]{this.database, this.viewName}), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        catch (LockException e) {
            throw new CommitFailedException(e);
        }
        finally {
            HiveOperationsBase.cleanupMetadataAndUnlock(this.io(), commitStatus, newMetadataLocation, lock);
        }
        HiveViewOperations.LOG.info("Committed to view {} with the new metadata location {}", (Object)this.fullName, (Object)newMetadataLocation);
    }

    private boolean checkCurrentMetadataLocation(String newMetadataLocation) {
        ViewMetadata metadata = this.refresh();
        return newMetadataLocation.equals(metadata.metadataFileLocation());
    }

    private static boolean hiveLockEnabled(Configuration conf) {
        return conf.getBoolean("iceberg.engine.hive.lock-enabled", true);
    }

    private Table newHMSView(ViewMetadata metadata) {
        long currentTimeMillis = System.currentTimeMillis();
        String hmsTableOwner = PropertyUtil.propertyAsString(metadata.properties(), "hive.metastore.table.owner", HiveHadoopUtil.currentUser());
        String sqlQuery = this.sqlFor(metadata);
        return new Table(this.table(), this.database(), hmsTableOwner, (int)currentTimeMillis / 1000, (int)currentTimeMillis / 1000, Integer.MAX_VALUE, null, Collections.emptyList(), Maps.newHashMap(), sqlQuery, sqlQuery, this.tableType().name());
    }

    private String sqlFor(ViewMetadata metadata) {
        SQLViewRepresentation closest = null;
        for (ViewRepresentation representation : metadata.currentVersion().representations()) {
            if (!(representation instanceof SQLViewRepresentation)) continue;
            SQLViewRepresentation sqlViewRepresentation = (SQLViewRepresentation)representation;
            if (sqlViewRepresentation.dialect().equalsIgnoreCase("hive")) {
                return sqlViewRepresentation.sql();
            }
            if (closest != null) continue;
            closest = sqlViewRepresentation;
        }
        return closest == null ? null : closest.sql();
    }

    @VisibleForTesting
    HiveLock lockObject() {
        if (HiveViewOperations.hiveLockEnabled(this.conf)) {
            return new MetastoreLock(this.conf, this.metaClients, this.catalogName, this.database, this.viewName);
        }
        return new NoLock();
    }

    @Override
    protected String viewName() {
        return this.fullName;
    }

    @Override
    public TableType tableType() {
        return TableType.VIRTUAL_VIEW;
    }

    @Override
    public ClientPool<IMetaStoreClient, TException> metaClients() {
        return this.metaClients;
    }

    @Override
    public long maxHiveTablePropertySize() {
        return this.maxHiveTablePropertySize;
    }

    @Override
    public String database() {
        return this.database;
    }

    @Override
    public String table() {
        return this.viewName;
    }

    @Override
    public FileIO io() {
        return this.fileIO;
    }

    private /* synthetic */ Boolean lambda$doCommit$2(String newMetadataLocation) {
        return this.checkCurrentMetadataLocation(newMetadataLocation);
    }

    private static /* synthetic */ boolean lambda$doCommit$1(ViewMetadata metadata, String key) {
        return !metadata.properties().containsKey(key);
    }
}

