/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.iceberg.io.DelegatingInputStream;
import org.apache.iceberg.io.DelegatingOutputStream;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopStreams {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopStreams.class);

    private HadoopStreams() {
    }

    static SeekableInputStream wrap(FSDataInputStream stream) {
        return new HadoopSeekableInputStream(stream);
    }

    static PositionOutputStream wrap(FSDataOutputStream stream) {
        return new HadoopPositionOutputStream(stream);
    }

    public static FSInputStream wrap(SeekableInputStream stream) {
        return new WrappedSeekableInputStream(stream);
    }

    private static class HadoopSeekableInputStream
    extends SeekableInputStream
    implements DelegatingInputStream {
        private final FSDataInputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        HadoopSeekableInputStream(FSDataInputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        @Override
        public InputStream getDelegate() {
            return this.stream;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        @Override
        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
                String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed input stream created by:\n\t{}", (Object)trace);
            }
        }
    }

    private static class HadoopPositionOutputStream
    extends PositionOutputStream
    implements DelegatingOutputStream {
        private final FSDataOutputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        HadoopPositionOutputStream(FSDataOutputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        @Override
        public OutputStream getDelegate() {
            return this.stream;
        }

        @Override
        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.stream.flush();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
            if (Thread.interrupted() && "org.apache.hadoop.fs.s3a.S3ABlockOutputStream".equals(this.stream.getWrappedStream().getClass().getName())) {
                throw new IOException("S3ABlockOutputStream failed to upload object after stream was closed");
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
                String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
                LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
            }
        }
    }

    private static class WrappedSeekableInputStream
    extends FSInputStream
    implements DelegatingInputStream {
        private final SeekableInputStream inputStream;

        private WrappedSeekableInputStream(SeekableInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public void seek(long pos) throws IOException {
            this.inputStream.seek(pos);
        }

        public long getPos() throws IOException {
            return this.inputStream.getPos();
        }

        public boolean seekToNewSource(long targetPos) throws IOException {
            throw new UnsupportedOperationException("seekToNewSource not supported");
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public InputStream getDelegate() {
            return this.inputStream;
        }
    }
}

