/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.auth;

import com.google.auth.oauth2.GoogleCredentials;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.catalog.SessionCatalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.gcp.auth.GoogleAuthSession;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleAuthManager
implements AuthManager {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAuthManager.class);
    private static final Splitter SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    public static final String DEFAULT_SCOPES = "https://www.googleapis.com/auth/cloud-platform";
    public static final String GCP_CREDENTIALS_PATH_PROPERTY = "gcp.auth.credentials-path";
    public static final String GCP_SCOPES_PROPERTY = "gcp.auth.scopes";
    private final String name;
    private GoogleCredentials credentials;
    private boolean initialized = false;

    public GoogleAuthManager(String managerName) {
        this.name = managerName;
    }

    public String name() {
        return this.name;
    }

    private void initialize(Map<String, String> properties) {
        block9: {
            if (this.initialized) {
                return;
            }
            String credentialsPath = properties.get(GCP_CREDENTIALS_PATH_PROPERTY);
            String scopesString = properties.getOrDefault(GCP_SCOPES_PROPERTY, DEFAULT_SCOPES);
            ImmutableList scopes = Strings.isNullOrEmpty(scopesString) ? ImmutableList.of() : ImmutableList.copyOf(SPLITTER.splitToList(scopesString));
            try {
                if (credentialsPath != null && !credentialsPath.isEmpty()) {
                    LOG.info("Using Google credentials from path: {}", (Object)credentialsPath);
                    try (FileInputStream credentialsStream = new FileInputStream(credentialsPath);){
                        this.credentials = GoogleCredentials.fromStream((InputStream)credentialsStream).createScoped(scopes);
                        break block9;
                    }
                }
                LOG.info("Using Application Default Credentials with scopes: {}", (Object)scopesString);
                this.credentials = GoogleCredentials.getApplicationDefault().createScoped(scopes);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to load Google credentials", e);
            }
        }
        this.initialized = true;
    }

    @Override
    public AuthSession initSession(RESTClient initClient, Map<String, String> properties) {
        return this.catalogSession(initClient, properties);
    }

    @Override
    public AuthSession catalogSession(RESTClient sharedClient, Map<String, String> properties) {
        this.initialize(properties);
        Preconditions.checkState(this.credentials != null, "GoogleAuthManager not initialized or failed to load credentials");
        return new GoogleAuthSession(this.credentials);
    }

    @Override
    public AuthSession contextualSession(SessionCatalog.SessionContext context, AuthSession parent) {
        return parent;
    }

    @Override
    public AuthSession tableSession(TableIdentifier table, Map<String, String> properties, AuthSession parent) {
        return parent;
    }

    @Override
    public void close() {
    }
}

