/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.kms.v1.DecryptRequest;
import com.google.cloud.kms.v1.DecryptResponse;
import com.google.cloud.kms.v1.EncryptRequest;
import com.google.cloud.kms.v1.EncryptResponse;
import com.google.cloud.kms.v1.KeyManagementServiceClient;
import com.google.cloud.kms.v1.KeyManagementServiceSettings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.iceberg.common.DynClasses;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.encryption.KeyManagementClient;
import org.apache.iceberg.gcp.GCPAuthUtils;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.io.CloseableGroup;

public class GcpKeyManagementClient
implements KeyManagementClient {
    private KeyManagementServiceClient kmsClient;
    private CloseableGroup closeableGroup = new CloseableGroup();

    @Override
    public void initialize(Map<String, String> properties) {
        this.closeableGroup = new CloseableGroup();
        this.closeableGroup.setSuppressCloseFailure(true);
        GCPProperties gcpProperties = new GCPProperties(properties);
        try {
            KeyManagementServiceSettings.Builder kmsBuilder = KeyManagementServiceSettings.newBuilder();
            if (gcpProperties.oauth2Token().isPresent()) {
                OAuth2Credentials oAuth2Credentials = GCPAuthUtils.oauth2CredentialsFromGcpProperties(gcpProperties, this.closeableGroup);
                kmsBuilder.setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)oAuth2Credentials));
            }
            this.kmsClient = KeyManagementServiceClient.create((KeyManagementServiceSettings)kmsBuilder.build());
            this.closeableGroup.addCloseable((AutoCloseable)this.kmsClient);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create GCP cloud KMS service client", e);
        }
    }

    @Override
    public ByteBuffer wrapKey(ByteBuffer key, String wrappingKeyId) {
        EncryptRequest.Builder requestBuilder = EncryptRequest.newBuilder().setName(wrappingKeyId);
        requestBuilder = ByteStringShim.setPlainText(requestBuilder, key);
        EncryptRequest encryptRequest = requestBuilder.build();
        EncryptResponse encryptResponse = this.kmsClient.encrypt(encryptRequest);
        key.position(0);
        return ByteBuffer.wrap(ByteStringShim.getCipherText(encryptResponse));
    }

    @Override
    public ByteBuffer unwrapKey(ByteBuffer wrappedKey, String wrappingKeyId) {
        DecryptRequest.Builder requestBuilder = DecryptRequest.newBuilder().setName(wrappingKeyId);
        requestBuilder = ByteStringShim.setCipherText(requestBuilder, wrappedKey);
        DecryptRequest decryptRequest = requestBuilder.build();
        DecryptResponse decryptResponse = this.kmsClient.decrypt(decryptRequest);
        wrappedKey.position(0);
        return ByteBuffer.wrap(ByteStringShim.getPlainText(decryptResponse));
    }

    @Override
    public void close() {
        try {
            this.closeableGroup.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static final class ByteStringShim {
        private static final String ORIGINAL_BYTE_STRING_CLASS_NAME = "com.google.protobuf.ByteString";
        private static final String SHADED_BYTE_STRING_CLASS_NAME = "org.apache.iceberg.gcp.shaded.com.google.protobuf.ByteString";
        private static final Class<?> BYTE_STRING_CLASS;
        private static final DynMethods.UnboundMethod SET_PLAIN_TEXT_METHOD;
        private static final DynMethods.UnboundMethod SET_CIPHER_TEXT_METHOD;
        private static final DynMethods.UnboundMethod GET_PLAIN_TEXT_METHOD;
        private static final DynMethods.UnboundMethod GET_CIPHER_TEXT_METHOD;
        private static final DynMethods.StaticMethod COPY_FROM_BYTEBUFFER_METHOD;
        private static final DynMethods.UnboundMethod TO_BYTE_ARRAY_METHOD;

        private ByteStringShim() {
        }

        static EncryptRequest.Builder setPlainText(EncryptRequest.Builder requestBuilder, ByteBuffer key) {
            Object byteStringKey = COPY_FROM_BYTEBUFFER_METHOD.invoke(key);
            return (EncryptRequest.Builder)SET_PLAIN_TEXT_METHOD.invoke(requestBuilder, byteStringKey);
        }

        static DecryptRequest.Builder setCipherText(DecryptRequest.Builder requestBuilder, ByteBuffer wrappedKey) {
            Object byteStringWrappedKey = COPY_FROM_BYTEBUFFER_METHOD.invoke(wrappedKey);
            return (DecryptRequest.Builder)SET_CIPHER_TEXT_METHOD.invoke(requestBuilder, byteStringWrappedKey);
        }

        static byte[] getCipherText(EncryptResponse response) {
            Object byteStringEncryptedKey = GET_CIPHER_TEXT_METHOD.invoke(response, new Object[0]);
            return (byte[])TO_BYTE_ARRAY_METHOD.invoke(byteStringEncryptedKey, new Object[0]);
        }

        static byte[] getPlainText(DecryptResponse response) {
            Object byteStringDecryptedKey = GET_PLAIN_TEXT_METHOD.invoke(response, new Object[0]);
            return (byte[])TO_BYTE_ARRAY_METHOD.invoke(byteStringDecryptedKey, new Object[0]);
        }

        static {
            Class byteStringClass = DynClasses.builder().impl(SHADED_BYTE_STRING_CLASS_NAME).orNull().build();
            if (byteStringClass == null) {
                byteStringClass = DynClasses.builder().impl(ORIGINAL_BYTE_STRING_CLASS_NAME).build();
            }
            BYTE_STRING_CLASS = byteStringClass;
            SET_PLAIN_TEXT_METHOD = new DynMethods.Builder("setPlaintext").hiddenImpl(EncryptRequest.Builder.class, BYTE_STRING_CLASS).build();
            SET_CIPHER_TEXT_METHOD = new DynMethods.Builder("setCiphertext").hiddenImpl(DecryptRequest.Builder.class, BYTE_STRING_CLASS).build();
            GET_PLAIN_TEXT_METHOD = new DynMethods.Builder("getPlaintext").hiddenImpl(DecryptResponse.class, new Class[0]).build();
            GET_CIPHER_TEXT_METHOD = new DynMethods.Builder("getCiphertext").hiddenImpl(EncryptResponse.class, new Class[0]).build();
            COPY_FROM_BYTEBUFFER_METHOD = new DynMethods.Builder("copyFrom").hiddenImpl(BYTE_STRING_CLASS, ByteBuffer.class).buildStatic();
            TO_BYTE_ARRAY_METHOD = new DynMethods.Builder("toByteArray").hiddenImpl(BYTE_STRING_CLASS, new Class[0]).build();
        }
    }
}

