/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.flink.source.reader.SplitWatermarkExtractor;
import org.apache.iceberg.flink.source.reader.WatermarkExtractorRecordEmitter;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;

@FunctionalInterface
@Internal
public interface SerializableRecordEmitter<T>
extends RecordEmitter<RecordAndPosition<T>, T, IcebergSourceSplit>,
Serializable {
    public static <T> SerializableRecordEmitter<T> defaultEmitter() {
        return (element, output, split) -> {
            output.collect(element.record());
            split.updatePosition(element.fileOffset(), element.recordOffset());
        };
    }

    public static <T> SerializableRecordEmitter<T> emitterWithWatermark(SplitWatermarkExtractor extractor) {
        return new WatermarkExtractorRecordEmitter(extractor);
    }
}

