/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalSerializers;
import org.apache.flink.table.types.logical.RowType;
import org.apache.iceberg.flink.FlinkRowData;
import org.apache.iceberg.flink.data.RowDataUtil;
import org.apache.iceberg.flink.source.reader.RecordFactory;

class RowDataRecordFactory
implements RecordFactory<RowData> {
    private final RowType rowType;
    private final TypeSerializer[] fieldSerializers;
    private final RowData.FieldGetter[] fieldGetters;

    RowDataRecordFactory(RowType rowType) {
        this.rowType = rowType;
        this.fieldSerializers = RowDataRecordFactory.createFieldSerializers(rowType);
        this.fieldGetters = RowDataRecordFactory.createFieldGetters(rowType);
    }

    static TypeSerializer[] createFieldSerializers(RowType rowType) {
        return (TypeSerializer[])rowType.getChildren().stream().map(InternalSerializers::create).toArray(TypeSerializer[]::new);
    }

    static RowData.FieldGetter[] createFieldGetters(RowType rowType) {
        RowData.FieldGetter[] fieldGetters = new RowData.FieldGetter[rowType.getFieldCount()];
        for (int i = 0; i < rowType.getFieldCount(); ++i) {
            fieldGetters[i] = FlinkRowData.createFieldGetter(rowType.getTypeAt(i), i);
        }
        return fieldGetters;
    }

    public RowData[] createBatch(int batchSize) {
        RowData[] arr = new RowData[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            arr[i] = new GenericRowData(this.rowType.getFieldCount());
        }
        return arr;
    }

    public void clone(RowData from, RowData[] batch, int position) {
        batch[position] = RowDataUtil.clone(from, batch[position], this.rowType, this.fieldSerializers, this.fieldGetters);
    }
}

