/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.annotation.Internal;

@Internal
class RecordLimiter {
    private final long limit;
    private final AtomicLong counter;

    static RecordLimiter create(long limit) {
        return new RecordLimiter(limit);
    }

    private RecordLimiter(long limit) {
        this.limit = limit;
        this.counter = new AtomicLong(0L);
    }

    public boolean reachedLimit() {
        return this.limit > 0L && this.counter.get() >= this.limit;
    }

    public void increment() {
        this.counter.incrementAndGet();
    }
}

