/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.iceberg.flink.source.reader.RecordAndPosition;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class ListBatchRecords<T>
implements RecordsWithSplitIds<RecordAndPosition<T>> {
    private String splitId;
    private final List<T> records;
    private final Set<String> finishedSplits;
    private final RecordAndPosition<T> recordAndPosition;
    private int position;

    ListBatchRecords(String splitId, List<T> records, int fileOffset, long startingRecordOffset, Set<String> finishedSplits) {
        this.splitId = splitId;
        this.records = records;
        this.finishedSplits = Preconditions.checkNotNull(finishedSplits, "finishedSplits can be empty but not null");
        this.recordAndPosition = new RecordAndPosition();
        this.recordAndPosition.set(null, fileOffset, startingRecordOffset);
        this.position = 0;
    }

    @Nullable
    public String nextSplit() {
        String nextSplit = this.splitId;
        this.splitId = null;
        return nextSplit;
    }

    @Nullable
    public RecordAndPosition<T> nextRecordFromSplit() {
        if (this.position < this.records.size()) {
            this.recordAndPosition.record(this.records.get(this.position));
            ++this.position;
            return this.recordAndPosition;
        }
        return null;
    }

    public Set<String> finishedSplits() {
        return this.finishedSplits;
    }

    public static <T> ListBatchRecords<T> forRecords(String splitId, List<T> records, int fileOffset, long startingRecordOffset) {
        return new ListBatchRecords<T>(splitId, records, fileOffset, startingRecordOffset, Collections.emptySet());
    }
}

