/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.reader;

import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.MetricGroup;

public class IcebergSourceReaderMetrics {
    private final Counter assignedSplits;
    private final Counter assignedBytes;
    private final Counter finishedSplits;
    private final Counter finishedBytes;
    private final Counter splitReaderFetchCalls;

    public IcebergSourceReaderMetrics(MetricGroup metrics, String fullTableName) {
        MetricGroup readerMetrics = metrics.addGroup("IcebergSourceReader").addGroup("table", fullTableName);
        this.assignedSplits = readerMetrics.counter("assignedSplits");
        this.assignedBytes = readerMetrics.counter("assignedBytes");
        this.finishedSplits = readerMetrics.counter("finishedSplits");
        this.finishedBytes = readerMetrics.counter("finishedBytes");
        this.splitReaderFetchCalls = readerMetrics.counter("splitReaderFetchCalls");
    }

    public void incrementAssignedSplits(long count) {
        this.assignedSplits.inc(count);
    }

    public void incrementAssignedBytes(long count) {
        this.assignedBytes.inc(count);
    }

    public void incrementFinishedSplits(long count) {
        this.finishedSplits.inc(count);
    }

    public void incrementFinishedBytes(long count) {
        this.finishedBytes.inc(count);
    }

    public void incrementSplitReaderFetchCalls(long count) {
        this.splitReaderFetchCalls.inc(count);
    }
}

