/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.io.IOException;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.iceberg.flink.source.enumerator.IcebergEnumeratorPosition;

class IcebergEnumeratorPositionSerializer
implements SimpleVersionedSerializer<IcebergEnumeratorPosition> {
    public static final IcebergEnumeratorPositionSerializer INSTANCE = new IcebergEnumeratorPositionSerializer();
    private static final int VERSION = 1;
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(128));

    IcebergEnumeratorPositionSerializer() {
    }

    public int getVersion() {
        return 1;
    }

    public byte[] serialize(IcebergEnumeratorPosition position) throws IOException {
        return this.serializeV1(position);
    }

    public IcebergEnumeratorPosition deserialize(int version, byte[] serialized) throws IOException {
        switch (version) {
            case 1: {
                return this.deserializeV1(serialized);
            }
        }
        throw new IOException("Unknown version: " + version);
    }

    private byte[] serializeV1(IcebergEnumeratorPosition position) throws IOException {
        DataOutputSerializer out = SERIALIZER_CACHE.get();
        out.writeBoolean(position.snapshotId() != null);
        if (position.snapshotId() != null) {
            out.writeLong(position.snapshotId().longValue());
        }
        out.writeBoolean(position.snapshotTimestampMs() != null);
        if (position.snapshotTimestampMs() != null) {
            out.writeLong(position.snapshotTimestampMs().longValue());
        }
        byte[] result = out.getCopyOfBuffer();
        out.clear();
        return result;
    }

    private IcebergEnumeratorPosition deserializeV1(byte[] serialized) throws IOException {
        DataInputDeserializer in = new DataInputDeserializer(serialized);
        Long snapshotId = null;
        if (in.readBoolean()) {
            snapshotId = in.readLong();
        }
        Long snapshotTimestampMs = null;
        if (in.readBoolean()) {
            snapshotTimestampMs = in.readLong();
        }
        if (snapshotId != null) {
            return IcebergEnumeratorPosition.of(snapshotId, snapshotTimestampMs);
        }
        return IcebergEnumeratorPosition.empty();
    }
}

