/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source.enumerator;

import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;

@ThreadSafe
class EnumerationHistory {
    private final int[] history;
    private int count;

    EnumerationHistory(int maxHistorySize) {
        this.history = new int[maxHistorySize];
    }

    synchronized void restore(int[] restoredHistory) {
        int startingOffset = 0;
        int restoreSize = restoredHistory.length;
        if (restoredHistory.length > this.history.length) {
            startingOffset = restoredHistory.length - this.history.length;
            restoreSize = this.history.length;
        }
        System.arraycopy(restoredHistory, startingOffset, this.history, 0, restoreSize);
        this.count = restoreSize;
    }

    synchronized int[] snapshot() {
        int len = this.history.length;
        if (this.count > len) {
            int[] copy = new int[len];
            int indexForOldest = this.count % len;
            System.arraycopy(this.history, indexForOldest, copy, 0, len - indexForOldest);
            System.arraycopy(this.history, 0, copy, len - indexForOldest, indexForOldest);
            return copy;
        }
        return Arrays.copyOfRange(this.history, 0, this.count);
    }

    synchronized void add(int splitCount) {
        int pos = this.count % this.history.length;
        this.history[pos] = splitCount;
        ++this.count;
    }

    @VisibleForTesting
    synchronized boolean hasFullHistory() {
        return this.count >= this.history.length;
    }

    synchronized boolean shouldPauseSplitDiscovery(int pendingSplitCountFromAssigner) {
        if (this.count < this.history.length) {
            return false;
        }
        int totalSplitCountFromRecentDiscovery = Arrays.stream(this.history).reduce(0, Integer::sum);
        return pendingSplitCountFromAssigner >= totalSplitCountFromRecentDiscovery;
    }
}

