/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.flink.annotation.Internal;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.IncrementalAppendScan;
import org.apache.iceberg.Scan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.flink.source.FlinkInputSplit;
import org.apache.iceberg.flink.source.ScanContext;
import org.apache.iceberg.flink.source.split.IcebergSourceSplit;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.Tasks;

@Internal
public class FlinkSplitPlanner {
    private FlinkSplitPlanner() {
    }

    static FlinkInputSplit[] planInputSplits(Table table, ScanContext context, ExecutorService workerPool) {
        FlinkInputSplit[] flinkInputSplitArray;
        block8: {
            CloseableIterable<CombinedScanTask> tasksIterable = FlinkSplitPlanner.planTasks(table, context, workerPool);
            try {
                ArrayList<CombinedScanTask> tasks = Lists.newArrayList(tasksIterable);
                FlinkInputSplit[] splits = new FlinkInputSplit[tasks.size()];
                boolean exposeLocality = context.exposeLocality();
                Tasks.range(tasks.size()).stopOnFailure().executeWith(exposeLocality ? workerPool : null).run(index -> {
                    CombinedScanTask task = (CombinedScanTask)tasks.get((int)index);
                    String[] hostnames = null;
                    if (exposeLocality) {
                        hostnames = Util.blockLocations(table.io(), task);
                    }
                    splits[index.intValue()] = new FlinkInputSplit((int)index, task, hostnames);
                });
                flinkInputSplitArray = splits;
                if (tasksIterable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tasksIterable != null) {
                        try {
                            tasksIterable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to process tasks iterable", e);
                }
            }
            tasksIterable.close();
        }
        return flinkInputSplitArray;
    }

    public static List<IcebergSourceSplit> planIcebergSourceSplits(Table table, ScanContext context, ExecutorService workerPool) {
        ArrayList<IcebergSourceSplit> arrayList;
        block8: {
            CloseableIterable<CombinedScanTask> tasksIterable = FlinkSplitPlanner.planTasks(table, context, workerPool);
            try {
                arrayList = Lists.newArrayList(CloseableIterable.transform(tasksIterable, IcebergSourceSplit::fromCombinedScanTask));
                if (tasksIterable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (tasksIterable != null) {
                        try {
                            tasksIterable.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to process task iterable: ", e);
                }
            }
            tasksIterable.close();
        }
        return arrayList;
    }

    static CloseableIterable<CombinedScanTask> planTasks(Table table, ScanContext context, ExecutorService workerPool) {
        ScanMode scanMode = FlinkSplitPlanner.checkScanMode(context);
        if (scanMode == ScanMode.INCREMENTAL_APPEND_SCAN) {
            IncrementalAppendScan scan = table.newIncrementalAppendScan();
            scan = FlinkSplitPlanner.refineScanWithBaseConfigs(scan, context, workerPool);
            if (context.startTag() != null) {
                Preconditions.checkArgument(table.snapshot(context.startTag()) != null, "Cannot find snapshot with tag %s", (Object)context.startTag());
                scan = (IncrementalAppendScan)scan.fromSnapshotExclusive(table.snapshot(context.startTag()).snapshotId());
            }
            if (context.startSnapshotId() != null) {
                Preconditions.checkArgument(context.startTag() == null, "START_SNAPSHOT_ID and START_TAG cannot both be set");
                scan = (IncrementalAppendScan)scan.fromSnapshotExclusive(context.startSnapshotId());
            }
            if (context.endTag() != null) {
                Preconditions.checkArgument(table.snapshot(context.endTag()) != null, "Cannot find snapshot with tag %s", (Object)context.endTag());
                scan = (IncrementalAppendScan)scan.toSnapshot(table.snapshot(context.endTag()).snapshotId());
            }
            if (context.endSnapshotId() != null) {
                Preconditions.checkArgument(context.endTag() == null, "END_SNAPSHOT_ID and END_TAG cannot both be set");
                scan = (IncrementalAppendScan)scan.toSnapshot(context.endSnapshotId());
            }
            return scan.planTasks();
        }
        TableScan scan = table.newScan();
        scan = FlinkSplitPlanner.refineScanWithBaseConfigs(scan, context, workerPool);
        if (context.snapshotId() != null) {
            scan = scan.useSnapshot(context.snapshotId());
        } else if (context.tag() != null) {
            scan = scan.useRef(context.tag());
        } else if (context.branch() != null) {
            scan = scan.useRef(context.branch());
        }
        if (context.asOfTimestamp() != null) {
            scan = scan.asOfTime(context.asOfTimestamp());
        }
        return scan.planTasks();
    }

    @VisibleForTesting
    static ScanMode checkScanMode(ScanContext context) {
        if (context.startSnapshotId() != null || context.endSnapshotId() != null || context.startTag() != null || context.endTag() != null) {
            return ScanMode.INCREMENTAL_APPEND_SCAN;
        }
        return ScanMode.BATCH;
    }

    private static <T extends Scan<T, FileScanTask, CombinedScanTask>> T refineScanWithBaseConfigs(T scan, ScanContext context, ExecutorService workerPool) {
        Scan refinedScan = (Scan)((Scan)((Scan)scan.caseSensitive(context.caseSensitive())).project(context.project())).planWith(workerPool);
        if (context.includeColumnStats()) {
            refinedScan = (Scan)refinedScan.includeColumnStats();
        }
        if (context.includeStatsForColumns() != null) {
            refinedScan = (Scan)refinedScan.includeColumnStats(context.includeStatsForColumns());
        }
        refinedScan = (Scan)refinedScan.option("read.split.target-size", context.splitSize().toString());
        refinedScan = (Scan)refinedScan.option("read.split.planning-lookback", context.splitLookback().toString());
        refinedScan = (Scan)refinedScan.option("read.split.open-file-cost", context.splitOpenFileCost().toString());
        if (context.filters() != null) {
            for (Expression filter : context.filters()) {
                refinedScan = (Scan)refinedScan.filter(filter);
            }
        }
        return (T)refinedScan;
    }

    @VisibleForTesting
    static enum ScanMode {
        BATCH,
        INCREMENTAL_APPEND_SCAN;

    }
}

