/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.encryption.InputFilesDecryptor;
import org.apache.iceberg.flink.data.StructRowData;
import org.apache.iceberg.flink.source.FileScanTaskReader;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;

@Internal
public class DataTaskReader
implements FileScanTaskReader<RowData> {
    private final Schema readSchema;

    public DataTaskReader(Schema readSchema) {
        this.readSchema = readSchema;
    }

    @Override
    public CloseableIterator<RowData> open(FileScanTask task, InputFilesDecryptor inputFilesDecryptor) {
        StructRowData row = new StructRowData(this.readSchema.asStruct());
        CloseableIterable<RowData> iterable = CloseableIterable.transform(task.asDataTask().rows(), row::setStruct);
        return iterable.iterator();
    }
}

