/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.iceberg.SortKey;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class SortKeySketchSerializer
extends ArrayOfItemsSerDe<SortKey>
implements Serializable {
    private static final int DEFAULT_SORT_KEY_SIZE = 128;
    private final TypeSerializer<SortKey> itemSerializer;
    private final ListSerializer<SortKey> listSerializer;
    private final DataInputDeserializer input;

    SortKeySketchSerializer(TypeSerializer<SortKey> itemSerializer) {
        this.itemSerializer = itemSerializer;
        this.listSerializer = new ListSerializer(itemSerializer);
        this.input = new DataInputDeserializer();
    }

    @Override
    public byte[] serializeToByteArray(SortKey item) {
        try {
            DataOutputSerializer output = new DataOutputSerializer(128);
            this.itemSerializer.serialize((Object)item, (DataOutputView)output);
            byte[] itemBytes = output.getSharedBuffer();
            int numBytes = output.length();
            byte[] out = new byte[numBytes + 4];
            ByteArrayUtil.copyBytes(itemBytes, 0, out, 4, numBytes);
            ByteArrayUtil.putIntLE(out, 0, numBytes);
            return out;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize sort key", e);
        }
    }

    @Override
    public byte[] serializeToByteArray(SortKey[] items) {
        try {
            DataOutputSerializer output = new DataOutputSerializer(128 * items.length);
            this.listSerializer.serialize(Arrays.asList(items), (DataOutputView)output);
            byte[] itemsBytes = output.getSharedBuffer();
            int numBytes = output.length();
            byte[] out = new byte[4 + numBytes];
            ByteArrayUtil.putIntLE(out, 0, numBytes);
            System.arraycopy(itemsBytes, 0, out, 4, numBytes);
            return out;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to serialize sort key", e);
        }
    }

    public SortKey[] deserializeFromMemory(Memory mem, long startingOffset, int numItems) {
        Preconditions.checkArgument(mem != null, "Invalid input memory: null");
        if (numItems <= 0) {
            return new SortKey[0];
        }
        long offset = startingOffset;
        Util.checkBounds(offset, 4L, mem.getCapacity());
        int numBytes = mem.getInt(offset);
        Util.checkBounds(offset += 4L, numBytes, mem.getCapacity());
        byte[] sortKeyBytes = new byte[numBytes];
        mem.getByteArray(offset, sortKeyBytes, 0, numBytes);
        this.input.setBuffer(sortKeyBytes);
        try {
            List sortKeys = this.listSerializer.deserialize((DataInputView)this.input);
            SortKey[] array = new SortKey[numItems];
            sortKeys.toArray(array);
            this.input.releaseArrays();
            return array;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to deserialize sort key sketch", e);
        }
    }

    @Override
    public int sizeOf(SortKey item) {
        return this.serializeToByteArray(item).length;
    }

    @Override
    public int sizeOf(Memory mem, long offset, int numItems) {
        Preconditions.checkArgument(mem != null, "Invalid input memory: null");
        if (numItems <= 0) {
            return 0;
        }
        Util.checkBounds(offset, 4L, mem.getCapacity());
        int numBytes = mem.getInt(offset);
        return 4 + numBytes;
    }

    @Override
    public String toString(SortKey item) {
        return item.toString();
    }

    @Override
    public Class<SortKey> getClassOfT() {
        return SortKey.class;
    }
}

