/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.flink.sink.shuffle;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.operators.coordination.OperatorCoordinator;
import org.apache.flink.runtime.operators.coordination.OperatorEventGateway;
import org.apache.flink.runtime.operators.coordination.OperatorEventHandler;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.CoordinatedOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.data.RowData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.flink.sink.shuffle.DataStatisticsCoordinatorProvider;
import org.apache.iceberg.flink.sink.shuffle.DataStatisticsOperator;
import org.apache.iceberg.flink.sink.shuffle.StatisticsOrRecord;
import org.apache.iceberg.flink.sink.shuffle.StatisticsType;

@Internal
public class DataStatisticsOperatorFactory
extends AbstractStreamOperatorFactory<StatisticsOrRecord>
implements CoordinatedOperatorFactory<StatisticsOrRecord>,
OneInputStreamOperatorFactory<RowData, StatisticsOrRecord> {
    private final Schema schema;
    private final SortOrder sortOrder;
    private final int downstreamParallelism;
    private final StatisticsType type;
    private final double closeFileCostWeightPercentage;

    public DataStatisticsOperatorFactory(Schema schema, SortOrder sortOrder, int downstreamParallelism, StatisticsType type, double closeFileCostWeightPercentage) {
        this.schema = schema;
        this.sortOrder = sortOrder;
        this.downstreamParallelism = downstreamParallelism;
        this.type = type;
        this.closeFileCostWeightPercentage = closeFileCostWeightPercentage;
    }

    public OperatorCoordinator.Provider getCoordinatorProvider(String operatorName, OperatorID operatorID) {
        return new DataStatisticsCoordinatorProvider(operatorName, operatorID, this.schema, this.sortOrder, this.downstreamParallelism, this.type, this.closeFileCostWeightPercentage);
    }

    public <T extends StreamOperator<StatisticsOrRecord>> T createStreamOperator(StreamOperatorParameters<StatisticsOrRecord> parameters) {
        OperatorID operatorId = parameters.getStreamConfig().getOperatorID();
        String operatorName = parameters.getStreamConfig().getOperatorName();
        OperatorEventGateway gateway = parameters.getOperatorEventDispatcher().getOperatorEventGateway(operatorId);
        DataStatisticsOperator rangeStatisticsOperator = new DataStatisticsOperator(parameters, operatorName, this.schema, this.sortOrder, gateway, this.downstreamParallelism, this.type);
        parameters.getOperatorEventDispatcher().registerEventHandler(operatorId, (OperatorEventHandler)rangeStatisticsOperator);
        return (T)((Object)rangeStatisticsOperator);
    }

    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return DataStatisticsOperator.class;
    }
}

